/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleMetadata;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.ModellerWidgetFactory;
import org.drools.workbench.screens.guided.rule.client.editor.MoveDownButton;
import org.drools.workbench.screens.guided.rule.client.editor.MoveUpButton;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModelEditor;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerActionSelectorPopup;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerConditionSelectorPopup;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerConfiguration;
import org.drools.workbench.screens.guided.rule.client.editor.events.TemplateVariablesChangedEvent;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.widget.FactTypeKnownValueChangeEvent;
import org.drools.workbench.screens.guided.rule.client.widget.FactTypeKnownValueChangeHandler;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.drools.workbench.screens.guided.rule.client.widget.attribute.AddAttributeWidget;
import org.drools.workbench.screens.guided.rule.client.widget.attribute.RuleAttributeWidget;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.CommonAltedImages;
import org.kie.workbench.common.widgets.client.ruleselector.RuleSelector;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.ClickableLabel;
import org.uberfire.ext.widgets.common.client.common.DirtyableHorizontalPane;
import org.uberfire.ext.widgets.common.client.common.DirtyableVerticalPane;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

public class RuleModeller
extends Composite
implements RuleModelEditor {
    private FlexTable layout;
    private RuleModel model;
    private Collection<RuleModellerActionPlugin> actionPlugins;
    private AsyncPackageDataModelOracle oracle;
    private RuleModellerConfiguration configuration;
    private Map<String, Object> serviceInvocationCache = new HashMap<String, Object>();
    private boolean showingOptions = false;
    private int currentLayoutRow = 0;
    private ModellerWidgetFactory widgetFactory;
    private EventBus eventBus;
    private boolean isReadOnly = false;
    private boolean isDSLEnabled = true;
    private List<RuleModellerWidget> lhsWidgets = new ArrayList<RuleModellerWidget>();
    private List<RuleModellerWidget> rhsWidgets = new ArrayList<RuleModellerWidget>();
    private boolean hasModifiedWidgets;
    private final Command onWidgetModifiedCommand = new Command(){

        public void execute() {
            RuleModeller.this.hasModifiedWidgets = true;
        }
    };
    private final RuleSelector ruleSelector = (RuleSelector)GWT.create(RuleSelector.class);

    public RuleModeller(RuleModel model, Collection<RuleModellerActionPlugin> actionPlugins, AsyncPackageDataModelOracle oracle, ModellerWidgetFactory widgetFactory, EventBus eventBus, boolean isReadOnly, boolean isDSLEnabled) {
        this(model, actionPlugins, oracle, widgetFactory, RuleModellerConfiguration.getDefault(), eventBus, isReadOnly);
        this.isDSLEnabled = isDSLEnabled;
    }

    public RuleModeller(RuleModel model, AsyncPackageDataModelOracle oracle, ModellerWidgetFactory widgetFactory, EventBus eventBus, boolean isReadOnly) {
        this(model, Collections.emptyList(), oracle, widgetFactory, eventBus, isReadOnly, true);
    }

    public RuleModeller(RuleModel model, Collection<RuleModellerActionPlugin> actionPlugins, AsyncPackageDataModelOracle oracle, ModellerWidgetFactory widgetFactory, RuleModellerConfiguration configuration, EventBus eventBus, boolean isReadOnly) {
        this.model = model;
        this.actionPlugins = actionPlugins;
        this.oracle = oracle;
        this.widgetFactory = widgetFactory;
        this.configuration = configuration;
        this.eventBus = eventBus;
        this.isReadOnly = isReadOnly;
        this.doLayout();
    }

    public void setRuleNamesForPackage(Collection<String> ruleNames) {
        this.ruleSelector.setRuleNames(ruleNames, this.model.name);
    }

    protected void doLayout() {
        this.layout = new FlexTable();
        this.initWidget();
        this.layout.setStyleName("model-builder-Background");
        this.initWidget((Widget)this.layout);
        this.setWidth("100%");
        this.setHeight("100%");
    }

    public void initWidget() {
        this.layout.removeAllRows();
        this.currentLayoutRow = 0;
        Image addPattern = GuidedRuleEditorImages508.INSTANCE.NewItem();
        addPattern.setTitle(GuidedRuleEditorResources.CONSTANTS.AddAConditionToThisRule());
        addPattern.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RuleModeller.this.showConditionSelector(null);
            }
        });
        this.layout.getColumnFormatter().setWidth(0, "20px");
        this.layout.getColumnFormatter().setWidth(1, "20px");
        this.layout.getColumnFormatter().setWidth(2, "48px");
        this.layout.getColumnFormatter().setWidth(4, "64px");
        if (this.showExtendedRuleDropdown()) {
            this.addExtendedRuleDropdown();
        }
        if (this.showLHS()) {
            this.layout.setWidget(this.currentLayoutRow, 0, (Widget)new SmallLabel("<b>" + GuidedRuleEditorResources.CONSTANTS.WHEN() + "</b>"));
            this.layout.getFlexCellFormatter().setColSpan(this.currentLayoutRow, 0, 4);
            if (!this.lockLHS()) {
                this.layout.setWidget(this.currentLayoutRow, 1, (Widget)addPattern);
            }
            ++this.currentLayoutRow;
            this.renderLhs(this.model);
        }
        if (this.showRHS()) {
            this.layout.setWidget(this.currentLayoutRow, 0, (Widget)new SmallLabel("<b>" + GuidedRuleEditorResources.CONSTANTS.THEN() + "</b>"));
            this.layout.getFlexCellFormatter().setColSpan(this.currentLayoutRow, 0, 4);
            Image addAction = GuidedRuleEditorImages508.INSTANCE.NewItem();
            addAction.setTitle(GuidedRuleEditorResources.CONSTANTS.AddAnActionToThisRule());
            addAction.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RuleModeller.this.showActionSelector(null);
                }
            });
            if (!this.lockRHS()) {
                this.layout.setWidget(this.currentLayoutRow, 1, (Widget)addAction);
            }
            ++this.currentLayoutRow;
            this.renderRhs(this.model);
        }
        if (this.showAttributes()) {
            final int optionsRowIndex = this.currentLayoutRow;
            if (!this.showingOptions) {
                ClickableLabel showMoreOptions = new ClickableLabel(GuidedRuleEditorResources.CONSTANTS.ShowOptions(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        RuleModeller.this.showingOptions = true;
                        RuleModeller.this.renderOptions(optionsRowIndex);
                    }
                });
                this.layout.setWidget(optionsRowIndex, 2, (Widget)showMoreOptions);
            } else {
                this.renderOptions(optionsRowIndex);
            }
        }
        ++this.currentLayoutRow;
        this.layout.setWidget(this.currentLayoutRow + 1, 3, (Widget)this.spacerWidget());
        this.layout.getCellFormatter().setHeight(this.currentLayoutRow + 1, 3, "100%");
    }

    private void addExtendedRuleDropdown() {
        this.layout.setWidget(this.currentLayoutRow, 0, (Widget)new SmallLabel("<b>" + GuidedRuleEditorResources.CONSTANTS.EXTENDS() + "</b>"));
        this.ruleSelector.setRuleName(this.model.parentName);
        this.ruleSelector.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ((RuleModeller)RuleModeller.this).model.parentName = (String)event.getValue();
            }
        });
        this.layout.setWidget(this.currentLayoutRow, 3, (Widget)this.ruleSelector);
        ++this.currentLayoutRow;
    }

    private void renderOptions(int optionsRowIndex) {
        this.layout.setWidget(optionsRowIndex, 2, (Widget)new SmallLabel(GuidedRuleEditorResources.CONSTANTS.optionsRuleModeller()));
        if (!this.isReadOnly) {
            this.layout.setWidget(optionsRowIndex, 4, this.getAddAttribute());
        }
        this.layout.setWidget(optionsRowIndex + 1, 3, (Widget)new RuleAttributeWidget(this, this.model, this.isReadOnly));
    }

    private boolean isLock(String attr) {
        if (this.isReadOnly()) {
            return true;
        }
        if (this.model.metadataList.length == 0) {
            return false;
        }
        for (RuleMetadata at : this.model.metadataList) {
            if (!at.getAttributeName().equals(attr)) continue;
            return true;
        }
        return false;
    }

    public boolean showRHS() {
        return !this.configuration.isHideRHS();
    }

    public boolean lockRHS() {
        return this.isLock("freeze_actions");
    }

    public boolean showLHS() {
        return !this.configuration.isHideLHS();
    }

    public boolean lockLHS() {
        return this.isLock("freeze_conditions");
    }

    private boolean showAttributes() {
        return !this.configuration.isHideAttributes();
    }

    private boolean showExtendedRuleDropdown() {
        return !this.configuration.isHideExtendedRuleDropdown();
    }

    public void refreshWidget() {
        this.initWidget();
    }

    private Widget getAddAttribute() {
        AddAttributeWidget addAttributeWidget = new AddAttributeWidget();
        addAttributeWidget.init(this);
        return addAttributeWidget.asWidget();
    }

    private void renderRhs(final RuleModel model) {
        for (int i = 0; i < model.rhs.length; ++i) {
            DirtyableVerticalPane widget = new DirtyableVerticalPane();
            widget.setWidth("100%");
            IAction action = model.rhs[i];
            Boolean readOnly = this.lockRHS() ? Boolean.valueOf(true) : null;
            RuleModellerWidget w = this.getWidgetFactory().getWidget(this, this.eventBus, action, readOnly);
            w.addOnModifiedCommand(this.onWidgetModifiedCommand);
            widget.add(this.wrapRHSWidget(model, i, w));
            widget.add((Widget)this.spacerWidget());
            this.layout.setWidget(this.currentLayoutRow, 0, (Widget)new DirtyableHorizontalPane());
            this.layout.setWidget(this.currentLayoutRow, 1, (Widget)new DirtyableHorizontalPane());
            this.layout.setWidget(this.currentLayoutRow, 2, this.wrapLineNumber(i + 1, false));
            this.layout.getFlexCellFormatter().setHorizontalAlignment(this.currentLayoutRow, 2, HasHorizontalAlignment.ALIGN_CENTER);
            this.layout.getFlexCellFormatter().setVerticalAlignment(this.currentLayoutRow, 2, HasVerticalAlignment.ALIGN_MIDDLE);
            this.layout.setWidget(this.currentLayoutRow, 3, (Widget)widget);
            this.layout.getFlexCellFormatter().setHorizontalAlignment(this.currentLayoutRow, 3, HasHorizontalAlignment.ALIGN_LEFT);
            this.layout.getFlexCellFormatter().setVerticalAlignment(this.currentLayoutRow, 3, HasVerticalAlignment.ALIGN_TOP);
            this.layout.getFlexCellFormatter().setWidth(this.currentLayoutRow, 3, "100%");
            this.layout.getRowFormatter().addStyleName(this.currentLayoutRow, i % 2 == 0 ? GuidedRuleEditorResources.INSTANCE.css().evenRow() : GuidedRuleEditorResources.INSTANCE.css().oddRow());
            if (!w.isFactTypeKnown()) {
                this.addInvalidPatternIcon();
                this.addFactTypeKnownValueChangeHandler(w, this.currentLayoutRow);
            }
            final int index = i;
            if (!this.lockRHS() && !w.isReadOnly()) {
                this.addActionsButtonsToLayout(GuidedRuleEditorResources.CONSTANTS.AddAnActionBelow(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        RuleModeller.this.showActionSelector(index + 1);
                    }
                }, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        model.moveRhsItemDown(index);
                        RuleModeller.this.refreshWidget();
                    }
                }, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        model.moveRhsItemUp(index);
                        RuleModeller.this.refreshWidget();
                    }
                });
            }
            this.rhsWidgets.add(w);
            ++this.currentLayoutRow;
        }
    }

    protected void showConditionSelector(Integer position) {
        RuleModellerConditionSelectorPopup popup = new RuleModellerConditionSelectorPopup(this.model, this, position, this.getDataModelOracle());
        popup.show();
    }

    protected void showActionSelector(Integer position) {
        RuleModellerActionSelectorPopup popup = this.ruleModellerActionSelectorPopup(position, this.actionPlugins);
        popup.show();
    }

    protected RuleModellerActionSelectorPopup ruleModellerActionSelectorPopup(Integer position, Collection<RuleModellerActionPlugin> actionPlugins) {
        return new RuleModellerActionSelectorPopup(this.model, this, actionPlugins, position, this.getDataModelOracle());
    }

    private void renderLhs(final RuleModel model) {
        for (int i = 0; i < model.lhs.length; ++i) {
            DirtyableVerticalPane vert = new DirtyableVerticalPane();
            vert.setWidth("100%");
            Boolean readOnly = this.lockLHS() ? Boolean.valueOf(true) : null;
            IPattern pattern = model.lhs[i];
            RuleModellerWidget widget = this.getWidgetFactory().getWidget(this, this.eventBus, pattern, readOnly);
            widget.addOnModifiedCommand(this.onWidgetModifiedCommand);
            vert.add(this.wrapLHSWidget(model, i, widget));
            vert.add((Widget)this.spacerWidget());
            this.layout.setWidget(this.currentLayoutRow, 0, (Widget)new DirtyableHorizontalPane());
            this.layout.setWidget(this.currentLayoutRow, 1, (Widget)new DirtyableHorizontalPane());
            this.layout.setWidget(this.currentLayoutRow, 2, this.wrapLineNumber(i + 1, true));
            this.layout.getFlexCellFormatter().setHorizontalAlignment(this.currentLayoutRow, 2, HasHorizontalAlignment.ALIGN_CENTER);
            this.layout.getFlexCellFormatter().setVerticalAlignment(this.currentLayoutRow, 2, HasVerticalAlignment.ALIGN_MIDDLE);
            this.layout.setWidget(this.currentLayoutRow, 3, (Widget)vert);
            this.layout.getFlexCellFormatter().setHorizontalAlignment(this.currentLayoutRow, 3, HasHorizontalAlignment.ALIGN_LEFT);
            this.layout.getFlexCellFormatter().setVerticalAlignment(this.currentLayoutRow, 3, HasVerticalAlignment.ALIGN_TOP);
            this.layout.getFlexCellFormatter().setWidth(this.currentLayoutRow, 3, "100%");
            this.layout.getRowFormatter().addStyleName(this.currentLayoutRow, i % 2 == 0 ? GuidedRuleEditorResources.INSTANCE.css().evenRow() : GuidedRuleEditorResources.INSTANCE.css().oddRow());
            if (!widget.isFactTypeKnown()) {
                this.addInvalidPatternIcon();
                this.addFactTypeKnownValueChangeHandler(widget, this.currentLayoutRow);
            }
            final int index = i;
            if (!this.lockLHS() && !widget.isReadOnly()) {
                this.addActionsButtonsToLayout(GuidedRuleEditorResources.CONSTANTS.AddAConditionBelow(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        RuleModeller.this.showConditionSelector(index + 1);
                    }
                }, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        model.moveLhsItemDown(index);
                        RuleModeller.this.refreshWidget();
                    }
                }, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        model.moveLhsItemUp(index);
                        RuleModeller.this.refreshWidget();
                    }
                });
            }
            this.lhsWidgets.add(widget);
            ++this.currentLayoutRow;
        }
    }

    private void addFactTypeKnownValueChangeHandler(final RuleModellerWidget widget, final int layoutRow) {
        widget.addFactTypeKnownValueChangeHandler(new FactTypeKnownValueChangeHandler(){

            @Override
            public void onValueChanged(FactTypeKnownValueChangeEvent factTypeKnownValueChangeEvent) {
                if (!widget.isFactTypeKnown()) {
                    RuleModeller.this.addInvalidPatternIcon();
                } else {
                    RuleModeller.this.clearLineIcons(layoutRow, 0);
                }
            }
        });
    }

    private void addInvalidPatternIcon() {
        Image image = GuidedRuleEditorImages508.INSTANCE.Error();
        image.setTitle(GuidedRuleEditorResources.CONSTANTS.InvalidPatternSectionDisabled());
        this.addLineIcon(this.currentLayoutRow, 0, image);
    }

    private HTML spacerWidget() {
        HTML h = new HTML("&nbsp;");
        h.setHeight("2px");
        return h;
    }

    private Widget wrapLineNumber(int number, boolean isLHSLine) {
        String id = "rhsLine";
        if (isLHSLine) {
            id = "lhsLine";
        }
        id = id + number;
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add((Widget)new HTML("<div class='form-field' id='" + id + "'>" + number + ".</div>"));
        return horiz;
    }

    private Widget wrapLHSWidget(final RuleModel model, int i, RuleModellerWidget w) {
        FlexTable wrapper = new FlexTable();
        Image remove = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
        remove.setTitle(GuidedRuleEditorResources.CONSTANTS.RemoveThisENTIREConditionAndAllTheFieldConstraintsThatBelongToIt());
        final int idx = i;
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisEntireConditionQ())) {
                    if (model.removeLhsItem(idx)) {
                        RuleModeller.this.refreshWidget();
                        TemplateVariablesChangedEvent tvce = new TemplateVariablesChangedEvent(model);
                        RuleModeller.this.eventBus.fireEventFromSource((GwtEvent)tvce, (Object)model);
                    } else {
                        ErrorPopup.showMessage((String)GuidedRuleEditorResources.CONSTANTS.CanTRemoveThatItemAsItIsUsedInTheActionPartOfTheRule());
                    }
                }
            }
        });
        wrapper.getColumnFormatter().setWidth(0, "100%");
        w.setWidth("100%");
        wrapper.setWidget(0, 0, (Widget)w);
        if (!this.lockLHS() && !w.isReadOnly() || !w.isFactTypeKnown()) {
            wrapper.setWidget(0, 1, (Widget)remove);
            wrapper.getColumnFormatter().setWidth(1, "20px");
        }
        return wrapper;
    }

    private Widget wrapRHSWidget(final RuleModel model, int i, RuleModellerWidget w) {
        FlexTable wrapper = new FlexTable();
        Image remove = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
        remove.setTitle(GuidedRuleEditorResources.CONSTANTS.RemoveThisAction());
        final int idx = i;
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisItem())) {
                    model.removeRhsItem(idx);
                    RuleModeller.this.refreshWidget();
                    TemplateVariablesChangedEvent tvce = new TemplateVariablesChangedEvent(model);
                    RuleModeller.this.eventBus.fireEventFromSource((GwtEvent)tvce, (Object)model);
                }
            }
        });
        wrapper.getColumnFormatter().setWidth(0, "100%");
        w.setWidth("100%");
        wrapper.setWidget(0, 0, (Widget)w);
        if (!this.lockRHS() && !w.isReadOnly() || !w.isFactTypeKnown()) {
            wrapper.setWidget(0, 1, (Widget)remove);
            wrapper.getColumnFormatter().setWidth(1, "20px");
        }
        return wrapper;
    }

    private void addLineIcon(int row, int col, Image icon) {
        Widget widget = this.layout.getWidget(row, col);
        if (widget instanceof DirtyableHorizontalPane) {
            DirtyableHorizontalPane horiz = (DirtyableHorizontalPane)widget;
            horiz.add((Widget)icon);
        }
    }

    private void clearLineIcons(int row, int col) {
        if (this.layout.getCellCount(row) <= col) {
            return;
        }
        Widget widget = this.layout.getWidget(row, col);
        if (widget instanceof DirtyableHorizontalPane) {
            DirtyableHorizontalPane horiz = (DirtyableHorizontalPane)widget;
            horiz.clear();
        }
    }

    private void clearLinesIcons(int col) {
        for (int i = 0; i < this.layout.getRowCount(); ++i) {
            this.clearLineIcons(i, col);
        }
    }

    private void addActionsButtonsToLayout(String title, ClickHandler addBelowListener, ClickHandler moveDownListener, ClickHandler moveUpListener) {
        DirtyableHorizontalPane hp = new DirtyableHorizontalPane();
        Image addPattern = CommonAltedImages.INSTANCE.NewItemBelow();
        addPattern.setTitle(title);
        addPattern.addClickHandler(addBelowListener);
        hp.add((Widget)addPattern);
        hp.add((Widget)new MoveDownButton(moveDownListener));
        hp.add((Widget)new MoveUpButton(moveUpListener));
        this.layout.setWidget(this.currentLayoutRow, 4, (Widget)hp);
        this.layout.getFlexCellFormatter().setHorizontalAlignment(this.currentLayoutRow, 4, HasHorizontalAlignment.ALIGN_CENTER);
        this.layout.getFlexCellFormatter().setVerticalAlignment(this.currentLayoutRow, 4, HasVerticalAlignment.ALIGN_MIDDLE);
    }

    public RuleModel getModel() {
        return this.model;
    }

    public Collection<RuleModellerActionPlugin> getActionPlugins() {
        return this.actionPlugins;
    }

    public boolean isVariableNameUsed(String name) {
        return this.model.isVariableNameUsed(name) || this.getDataModelOracle().isGlobalVariable(name);
    }

    public AsyncPackageDataModelOracle getDataModelOracle() {
        return this.oracle;
    }

    public ModellerWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    @Override
    public RuleModeller getRuleModeller() {
        return this;
    }

    public Map<String, Object> getServiceInvocationCache() {
        return this.serviceInvocationCache;
    }

    public boolean isTemplate() {
        return this.widgetFactory.isTemplate();
    }

    public Path getPath() {
        return this.oracle.getResourcePath();
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isDSLEnabled() {
        return this.isDSLEnabled;
    }
}

