/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.soup.project.datamodel.oracle.DropDownData;
import org.kie.workbench.common.widgets.client.widget.EnumDropDownUtilities;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.DropDownValueChanged;

public class EnumDropDown
extends SimplePanel {
    private final DropDownValueChanged valueChangedCommand;
    private final Path resource;
    private final ListBox listBox;
    private EnumDropDownUtilities utilities = new EnumDropDownUtilities(){

        protected int addItems(ListBox listBox) {
            return 0;
        }

        protected void selectItem(ListBox listBox) {
            int itemCount = listBox.getItemCount();
            listBox.setEnabled(itemCount > 0);
            if (itemCount > 0) {
                listBox.setSelectedIndex(0);
                Scheduler.get().scheduleFinally(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        EnumDropDown.this.valueChangedCommand.valueChanged(EnumDropDown.this.encodeSelectedItems(), EnumDropDown.this.encodeSelectedItems());
                    }
                });
            }
        }
    };
    private TextBox textBox = new TextBox();

    public EnumDropDown(String currentValue, DropDownValueChanged valueChanged, DropDownData dropData, Path resource) {
        this(currentValue, valueChanged, dropData, false, resource);
    }

    public EnumDropDown(String currentValue, final DropDownValueChanged valueChanged, DropDownData dropData, boolean multipleSelect, Path resource) {
        this.listBox = new ListBox(multipleSelect);
        this.valueChangedCommand = valueChanged;
        this.resource = resource;
        this.listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                EnumDropDown.this.valueChangedCommand.valueChanged(EnumDropDown.this.encodeSelectedItems(), EnumDropDown.this.encodeSelectedItems());
            }
        });
        this.textBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                valueChanged.valueChanged(EnumDropDown.this.textBox.getValue(), EnumDropDown.this.textBox.getValue());
            }
        });
        this.setDropDownData(currentValue, dropData);
    }

    String encodeSelectedItems() {
        if (this.listBox.getItemCount() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.listBox.isMultipleSelect()) {
            boolean first = true;
            buffer.append("( ");
            for (int i = 0; i < this.listBox.getItemCount(); ++i) {
                if (!this.listBox.isItemSelected(i)) continue;
                if (!first) {
                    buffer.append(",");
                }
                first = false;
                buffer.append("\"");
                buffer.append(this.listBox.getValue(i));
                buffer.append("\"");
            }
            buffer.append(" )");
        } else {
            buffer.append(this.listBox.getValue(this.listBox.getSelectedIndex()));
        }
        return buffer.toString();
    }

    public void setDropDownData(String currentValue, DropDownData dropData) {
        if (dropData == null) {
            this.textBox.setText(currentValue);
            this.setEditorWidget((Widget)this.textBox);
        } else {
            this.utilities.setDropDownData(currentValue, dropData, this.listBox.isMultipleSelect(), this.resource, this.listBox);
            this.setEditorWidget((Widget)this.listBox);
        }
    }

    private void setEditorWidget(Widget widget) {
        this.clear();
        this.add(widget);
    }

    public String getValue() {
        if (this.getWidget().equals(this.listBox)) {
            if (this.listBox.getSelectedIndex() != -1) {
                return this.listBox.getValue(this.listBox.getSelectedIndex());
            }
            return "";
        }
        return this.textBox.getValue();
    }
}

