/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor.validator;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromEntryPointFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.resources.i18n.Constants;
import org.kie.soup.commons.validation.PortablePreconditions;

public class GuidedRuleEditorValidator {
    private final List<String> errors = new ArrayList<String>();
    private final RuleModel model;
    private final Constants constants;

    public GuidedRuleEditorValidator(RuleModel model, Constants constants) {
        this.model = (RuleModel)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.constants = (Constants)PortablePreconditions.checkNotNull((String)"constants", (Object)constants);
    }

    public boolean isValid() {
        if (this.model.lhs.length == 0) {
            return true;
        }
        this.validateIPatterns(this.model.lhs);
        return this.errors.isEmpty();
    }

    private void validateIPatterns(IPattern[] patterns) {
        if (patterns == null) {
            return;
        }
        for (IPattern iPattern : patterns) {
            this.validateIPattern(iPattern);
        }
    }

    private void validateIPattern(IPattern iPattern) {
        if (iPattern instanceof FromEntryPointFactPattern) {
            this.validateFromEntryPointFactPattern((FromEntryPointFactPattern)iPattern);
        } else if (iPattern instanceof FromAccumulateCompositeFactPattern) {
            this.validateFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)iPattern);
        } else if (iPattern instanceof FromCollectCompositeFactPattern) {
            this.validateFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)iPattern);
        } else if (iPattern instanceof FromCompositeFactPattern) {
            this.validateFromCompositeFactPattern((FromCompositeFactPattern)iPattern);
        } else if (iPattern instanceof CompositeFactPattern) {
            this.validateCompositeFactPattern((CompositeFactPattern)iPattern);
        } else if (iPattern instanceof FactPattern) {
            this.validateFactPattern((FactPattern)iPattern);
        }
    }

    private void validateFromEntryPointFactPattern(FromEntryPointFactPattern fromEntryPointFactPattern) {
        this.hasFactPatternSet((FromCompositeFactPattern)fromEntryPointFactPattern);
        this.hasEntryPoint(fromEntryPointFactPattern);
    }

    private void hasEntryPoint(FromEntryPointFactPattern fromEntryPointFactPattern) {
        if (this.isStringNullOrEmpty(fromEntryPointFactPattern.getEntryPointName())) {
            this.errors.add(this.constants.PleaseSetTheEntryPoint());
        }
    }

    private void validateCompositeFactPattern(CompositeFactPattern compositeFactPattern) {
        this.hasPatterns(compositeFactPattern);
        this.validateIPatterns((IPattern[])compositeFactPattern.getPatterns());
    }

    private void validateFromCompositeFactPattern(FromCompositeFactPattern fromCompositeFactPattern) {
        this.hasFactPatternSet(fromCompositeFactPattern);
        this.hasExpressionBinding(fromCompositeFactPattern);
        this.validateFactPattern(fromCompositeFactPattern.getFactPattern());
    }

    private void hasFactPatternSet(FromCompositeFactPattern fromCompositeFactPattern) {
        if (fromCompositeFactPattern.getFactPattern() == null) {
            this.reportMandatoryFieldsError();
        }
    }

    private void validateFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern fromAccumulateCompositeFactPattern) {
        this.validateIPattern(fromAccumulateCompositeFactPattern.getSourcePattern());
        this.validateIPattern((IPattern)fromAccumulateCompositeFactPattern.getFactPattern());
        if (this.isExpressionBindingMissing((FromCompositeFactPattern)fromAccumulateCompositeFactPattern) && this.isStringNullOrEmpty(fromAccumulateCompositeFactPattern.getFunction()) && this.isAccumulateMissing(fromAccumulateCompositeFactPattern)) {
            this.reportMissingSource();
        }
    }

    private void validateFromCollectCompositeFactPattern(FromCollectCompositeFactPattern fromCollectCompositeFactPattern) {
        if (fromCollectCompositeFactPattern.getRightPattern() == null) {
            this.reportMandatoryFieldsError();
        } else if (fromCollectCompositeFactPattern.getFactPattern() == null) {
            this.reportMandatoryFieldsError();
        } else {
            this.validateIPattern(fromCollectCompositeFactPattern.getRightPattern());
        }
        this.validateIPattern((IPattern)fromCollectCompositeFactPattern.getFactPattern());
    }

    private boolean isAccumulateMissing(FromAccumulateCompositeFactPattern fromAccumulateCompositeFactPattern) {
        return this.isStringNullOrEmpty(fromAccumulateCompositeFactPattern.getActionCode()) && this.isStringNullOrEmpty(fromAccumulateCompositeFactPattern.getResultCode()) && this.isStringNullOrEmpty(fromAccumulateCompositeFactPattern.getResultCode()) && this.isStringNullOrEmpty(fromAccumulateCompositeFactPattern.getInitCode());
    }

    private boolean isStringNullOrEmpty(String actionCode) {
        return actionCode == null || actionCode.isEmpty();
    }

    private void hasExpressionBinding(FromCompositeFactPattern fromCompositeFactPattern) {
        if (this.isExpressionBindingMissing(fromCompositeFactPattern)) {
            this.reportMissingSource();
        }
    }

    private void reportMissingSource() {
        this.errors.add(this.constants.WhenUsingFromTheSourceNeedsToBeSet());
    }

    private boolean isExpressionBindingMissing(FromCompositeFactPattern fromCompositeFactPattern) {
        return fromCompositeFactPattern.getExpression().getBinding() == null && fromCompositeFactPattern.getExpression().getParts().isEmpty();
    }

    private void hasPatterns(CompositeFactPattern iPattern) {
        if (iPattern.getPatterns() == null) {
            this.reportMandatoryFieldsError();
        } else if (iPattern.getPatterns().length == 0) {
            this.reportMandatoryFieldsError();
        }
    }

    private void validateFactPattern(FactPattern factPattern) {
        if (factPattern == null || factPattern.getConstraintList() == null || factPattern.getConstraintList().getConstraints() == null) {
            return;
        }
        for (FieldConstraint constraint : factPattern.getConstraintList().getConstraints()) {
            SingleFieldConstraint singleFieldConstraint;
            if (!(constraint instanceof SingleFieldConstraint) || !this.areOperatorAndValueInvalid(singleFieldConstraint = (SingleFieldConstraint)constraint)) continue;
            this.errors.add(this.constants.FactType0HasAField1ThatHasAnOperatorSetButNoValuePleaseAddAValueOrRemoveTheOperator(factPattern.getFactType(), singleFieldConstraint.getFieldName()));
        }
    }

    private boolean areOperatorAndValueInvalid(SingleFieldConstraint singleFieldConstraint) {
        if (singleFieldConstraint.getConstraintValueType() == 1 && "String".equals(singleFieldConstraint.getFieldType())) {
            return false;
        }
        return singleFieldConstraint.getOperator() != null && !singleFieldConstraint.getOperator().equals("== null") && !singleFieldConstraint.getOperator().equals("!= null") && singleFieldConstraint.getValue() == null && singleFieldConstraint.getExpressionValue().isEmpty();
    }

    private void reportMandatoryFieldsError() {
        this.errors.add(this.constants.AreasMarkedWithRedAreMandatoryPleaseSetAValueBeforeSaving());
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

