/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.user.client.Command;
import org.drools.workbench.models.datamodel.rule.BaseSingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.editor.ConstraintValueChangeHandler;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ConstraintValueChangeHandlerTest {
    @Mock
    private BaseSingleFieldConstraint constraint;
    @Mock
    private Command onChangeCommand;
    @Mock
    private ValueChangeEvent valueChangeEvent;
    private ConstraintValueChangeHandler handler;

    @Before
    public void setUp() throws Exception {
        this.handler = new ConstraintValueChangeHandler(this.constraint, this.onChangeCommand);
    }

    @Test
    public void alterValueForLists() {
        ((BaseSingleFieldConstraint)Mockito.doReturn((Object)"in").when((Object)this.constraint)).getOperator();
        ((ValueChangeEvent)Mockito.doReturn((Object)"a,\\\"b,c\\\",d").when((Object)this.valueChangeEvent)).getValue();
        this.handler.onValueChange(this.valueChangeEvent);
        ((Command)Mockito.verify((Object)this.onChangeCommand)).execute();
        ((BaseSingleFieldConstraint)Mockito.verify((Object)this.constraint)).setValue("a,\"b,c\",d");
    }

    @Test
    public void doNotAlterValue() {
        ((BaseSingleFieldConstraint)Mockito.doReturn((Object)"==").when((Object)this.constraint)).getOperator();
        ((ValueChangeEvent)Mockito.doReturn((Object)"\"hello\"").when((Object)this.valueChangeEvent)).getValue();
        this.handler.onValueChange(this.valueChangeEvent);
        ((Command)Mockito.verify((Object)this.onChangeCommand)).execute();
        ((BaseSingleFieldConstraint)Mockito.verify((Object)this.constraint)).setValue("\"hello\"");
    }

    @Test
    public void nullCommand() {
        this.handler = new ConstraintValueChangeHandler(this.constraint, null);
        this.handler.onValueChange(this.valueChangeEvent);
        ((Command)Mockito.verify((Object)this.onChangeCommand, (VerificationMode)Mockito.never())).execute();
    }
}

