/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerActionSelectorPopup;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerSelectorFilter;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.ListBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@WithClassesToStub(value={Heading.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class RuleModellerActionSelectorPopupTest {
    private static final String ACTION_ID = "modify score id";
    private static final String ACTION_DESCRIPTION = "modify score";
    @Mock
    private RuleModeller ruleModeller;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private RuleModellerActionPlugin actionPlugin;
    @Mock
    private IAction iAction;
    @Mock
    private ListBox listBox;
    @GwtMock
    private RuleModellerSelectorFilter filterWidget;
    @Captor
    private ArgumentCaptor<String> keyCaptor;
    @Captor
    private ArgumentCaptor<Command> commandArgumentCaptor;
    private RuleModel model;
    private RuleModellerActionSelectorPopup popup;

    @Before
    public void setUp() {
        GwtMockito.useProviderForType(ListBox.class, aClass -> this.listBox);
        this.model = (RuleModel)Mockito.spy((Object)new RuleModel());
        Mockito.when((Object)this.oracle.getDSLActions()).thenReturn(Collections.singletonList(new DSLSentence(){
            {
                this.setDefinition("dslSentence");
            }
        }));
        Mockito.when((Object)this.oracle.getFactTypes()).thenReturn((Object)new String[]{"Applicant"});
        Mockito.when((Object)this.oracle.getGlobalVariables()).thenReturn((Object)new String[]{"$global"});
        Mockito.when((Object)this.ruleModeller.isDSLEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.actionPlugin.getId()).thenReturn((Object)ACTION_ID);
        Mockito.when((Object)this.actionPlugin.getActionAddDescription()).thenReturn((Object)ACTION_DESCRIPTION);
        this.popup = (RuleModellerActionSelectorPopup)Mockito.spy((Object)new RuleModellerActionSelectorPopup(this.model, this.ruleModeller, Collections.singletonList(this.actionPlugin), Integer.valueOf(0), this.oracle));
        Mockito.reset((Object[])new RuleModel[]{this.model});
    }

    @Test
    public void checkAddUpdateNotModifyGetsPatternBindings() {
        this.popup.addUpdateNotModify(false);
        ((RuleModel)Mockito.verify((Object)this.model)).getLHSPatternVariables();
    }

    @Test
    public void checkAddRetractionsGetsPatternBindings() {
        this.popup.addRetractions(false);
        ((RuleModel)Mockito.verify((Object)this.model)).getLHSPatternVariables();
    }

    @Test
    public void checkAddModifiesGetsLhsBindings() {
        this.popup.addModifies(false);
        ((RuleModel)Mockito.verify((Object)this.model)).getAllLHSVariables();
    }

    @Test
    public void checkAddCallMethodOnGetsAllBindings() {
        this.popup.addCallMethodOn(false);
        ((RuleModel)Mockito.verify((Object)this.model)).getAllLHSVariables();
        ((RuleModel)Mockito.verify((Object)this.model)).getRHSBoundFacts();
    }

    @Test
    public void testActionPlugins() throws Exception {
        Mockito.reset((Object[])new RuleModellerActionPlugin[]{this.actionPlugin});
        ((RuleModellerActionPlugin)Mockito.doReturn((Object)ACTION_DESCRIPTION).when((Object)this.actionPlugin)).getActionAddDescription();
        ((RuleModellerActionPlugin)Mockito.doReturn((Object)ACTION_ID).when((Object)this.actionPlugin)).getId();
        ((RuleModellerActionPlugin)Mockito.doReturn((Object)this.iAction).when((Object)this.actionPlugin)).createIAction((RuleModeller)Matchers.eq((Object)this.ruleModeller));
        this.popup.getContent();
        ((RuleModellerActionPlugin)Mockito.verify((Object)this.actionPlugin)).createIAction(this.ruleModeller);
        ((RuleModellerActionPlugin)Mockito.verify((Object)this.actionPlugin)).addPluginToActionList((RuleModeller)Matchers.eq((Object)this.ruleModeller), (Command)this.commandArgumentCaptor.capture());
        Mockito.reset((Object[])new ListBox[]{this.listBox});
        ((Command)this.commandArgumentCaptor.getValue()).execute();
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem((String)Matchers.eq((Object)ACTION_DESCRIPTION), (String)Matchers.eq((Object)ACTION_ID));
        Assertions.assertThat((Map)this.popup.cmds).containsKeys((Object[])new String[]{ACTION_ID});
        Mockito.reset((Object[])new ListBox[]{this.listBox});
        ((ListBox)Mockito.doReturn((Object)"123").when((Object)this.listBox)).getValue(Matchers.anyInt());
        ((com.google.gwt.user.client.Command)this.popup.cmds.get(ACTION_ID)).execute();
        ((RuleModel)Mockito.verify((Object)this.model)).addRhsItem(this.iAction, 123);
        ((RuleModellerActionSelectorPopup)Mockito.verify((Object)this.popup)).hide();
    }

    @Test
    public void testLoadContentFiltered() throws Exception {
        Mockito.reset((Object[])new Object[]{this.listBox, this.actionPlugin});
        Mockito.when((Object)this.actionPlugin.getId()).thenReturn((Object)ACTION_ID);
        Mockito.when((Object)this.actionPlugin.getActionAddDescription()).thenReturn((Object)ACTION_DESCRIPTION);
        Mockito.when((Object)this.filterWidget.getFilterText()).thenReturn((Object)"cheese");
        this.popup = new RuleModellerActionSelectorPopup(this.model, this.ruleModeller, Collections.singletonList(this.actionPlugin), Integer.valueOf(0), this.oracle);
        ((RuleModellerActionPlugin)Mockito.verify((Object)this.actionPlugin)).addPluginToActionList((RuleModeller)Matchers.eq((Object)this.ruleModeller), (Command)this.commandArgumentCaptor.capture());
        ((Command)this.commandArgumentCaptor.getValue()).execute();
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.atLeastOnce())).addItem((String)this.keyCaptor.capture(), Matchers.anyString());
        List keys = this.keyCaptor.getAllValues();
        Assertions.assertThat((List)keys).containsExactly((Object[])new String[]{"ChangeFieldValuesOf0($global)", "..................", "AddFreeFormDrl", "..................", "CallMethodOn0($global)", "..................", ACTION_DESCRIPTION});
    }

    @Test
    public void testLoadContentFilteredFactMatched() throws Exception {
        Mockito.reset((Object[])new Object[]{this.listBox, this.actionPlugin});
        Mockito.when((Object)this.actionPlugin.getId()).thenReturn((Object)ACTION_ID);
        Mockito.when((Object)this.actionPlugin.getActionAddDescription()).thenReturn((Object)ACTION_DESCRIPTION);
        Mockito.when((Object)this.filterWidget.getFilterText()).thenReturn((Object)"applicant");
        this.popup = new RuleModellerActionSelectorPopup(this.model, this.ruleModeller, Collections.singletonList(this.actionPlugin), Integer.valueOf(0), this.oracle);
        ((RuleModellerActionPlugin)Mockito.verify((Object)this.actionPlugin)).addPluginToActionList((RuleModeller)Matchers.eq((Object)this.ruleModeller), (Command)this.commandArgumentCaptor.capture());
        ((Command)this.commandArgumentCaptor.getValue()).execute();
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.atLeastOnce())).addItem((String)this.keyCaptor.capture(), Matchers.anyString());
        List keys = this.keyCaptor.getAllValues();
        Assertions.assertThat((List)keys).containsExactly((Object[])new String[]{"ChangeFieldValuesOf0($global)", "..................", "InsertFact0(Applicant)", "..................", "LogicallyInsertFact0(Applicant)", "..................", "AddFreeFormDrl", "..................", "CallMethodOn0($global)", "..................", ACTION_DESCRIPTION});
    }

    @Test
    public void testLoadContentDslSentenceMatched() throws Exception {
        Mockito.reset((Object[])new Object[]{this.listBox, this.actionPlugin});
        Mockito.when((Object)this.actionPlugin.getId()).thenReturn((Object)ACTION_ID);
        Mockito.when((Object)this.actionPlugin.getActionAddDescription()).thenReturn((Object)ACTION_DESCRIPTION);
        Mockito.when((Object)this.filterWidget.getFilterText()).thenReturn((Object)"dsl");
        this.popup = new RuleModellerActionSelectorPopup(this.model, this.ruleModeller, Collections.singletonList(this.actionPlugin), Integer.valueOf(0), this.oracle);
        ((RuleModellerActionPlugin)Mockito.verify((Object)this.actionPlugin)).addPluginToActionList((RuleModeller)Matchers.eq((Object)this.ruleModeller), (Command)this.commandArgumentCaptor.capture());
        ((Command)this.commandArgumentCaptor.getValue()).execute();
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.atLeastOnce())).addItem((String)this.keyCaptor.capture(), Matchers.anyString());
        List keys = this.keyCaptor.getAllValues();
        Assertions.assertThat((List)keys).containsExactly((Object[])new String[]{"dslSentence", "..................", "ChangeFieldValuesOf0($global)", "..................", "AddFreeFormDrl", "..................", "CallMethodOn0($global)", "..................", ACTION_DESCRIPTION});
    }

    @Test
    public void testLoadContentBothDslSentenceAndFactMatched() throws Exception {
        Mockito.reset((Object[])new Object[]{this.listBox, this.actionPlugin});
        Mockito.when((Object)this.actionPlugin.getId()).thenReturn((Object)ACTION_ID);
        Mockito.when((Object)this.actionPlugin.getActionAddDescription()).thenReturn((Object)ACTION_DESCRIPTION);
        Mockito.when((Object)this.filterWidget.getFilterText()).thenReturn((Object)"l");
        this.popup = new RuleModellerActionSelectorPopup(this.model, this.ruleModeller, Collections.singletonList(this.actionPlugin), Integer.valueOf(0), this.oracle);
        ((RuleModellerActionPlugin)Mockito.verify((Object)this.actionPlugin)).addPluginToActionList((RuleModeller)Matchers.eq((Object)this.ruleModeller), (Command)this.commandArgumentCaptor.capture());
        ((Command)this.commandArgumentCaptor.getValue()).execute();
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.atLeastOnce())).addItem((String)this.keyCaptor.capture(), Matchers.anyString());
        List keys = this.keyCaptor.getAllValues();
        Assertions.assertThat((List)keys).containsExactly((Object[])new String[]{"dslSentence", "..................", "ChangeFieldValuesOf0($global)", "..................", "InsertFact0(Applicant)", "..................", "LogicallyInsertFact0(Applicant)", "..................", "AddFreeFormDrl", "..................", "CallMethodOn0($global)", "..................", ACTION_DESCRIPTION});
    }

    @Test
    public void testLoadContentUnfiltered() throws Exception {
        ((RuleModellerActionPlugin)Mockito.verify((Object)this.actionPlugin)).addPluginToActionList((RuleModeller)Matchers.eq((Object)this.ruleModeller), (Command)this.commandArgumentCaptor.capture());
        ((Command)this.commandArgumentCaptor.getValue()).execute();
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.atLeastOnce())).addItem((String)this.keyCaptor.capture(), Matchers.anyString());
        List keys = this.keyCaptor.getAllValues();
        Assertions.assertThat((List)keys).containsExactly((Object[])new String[]{"dslSentence", "..................", "ChangeFieldValuesOf0($global)", "..................", "InsertFact0(Applicant)", "..................", "LogicallyInsertFact0(Applicant)", "..................", "AddFreeFormDrl", "..................", "CallMethodOn0($global)", "..................", ACTION_DESCRIPTION});
    }
}

