/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import com.google.gwtmockito.fakes.FakeProvider;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.widget.FromCollectCompositeFactPatternWidget;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;

@WithClassesToStub(value={RootPanel.class, Text.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class FromCollectCompositeFactPatternWidgetTest {
    private List<String> collectionTypes;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private RuleModeller ruleModeller;
    @Mock
    private EventBus eventBus;
    @Mock
    private FromCollectCompositeFactPattern pattern;
    @Mock
    private ListBox listBox;
    FromCollectCompositeFactPatternWidget fromCollectWidget;

    @Before
    public void setUp() throws Exception {
        this.fromCollectWidget = new FromCollectCompositeFactPatternWidget(this.ruleModeller, this.eventBus, this.pattern);
        GwtMockito.useProviderForType(ListBox.class, (FakeProvider)new ListBoxFakeProvider());
        this.collectionTypes = new ArrayList<String>(){
            {
                this.add("ArrayList");
                this.add("HashSet");
            }
        };
        Mockito.when((Object)this.ruleModeller.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.oracle.getAvailableCollectionTypes()).thenReturn(this.collectionTypes);
    }

    @Test
    public void testShowFactTypeSelector() throws Exception {
        this.fromCollectWidget.showFactTypeSelector();
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem("ArrayList", "ArrayList");
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem("HashSet", "HashSet");
    }

    private class ListBoxFakeProvider
    implements FakeProvider<ListBox> {
        private ListBoxFakeProvider() {
        }

        public ListBox getFake(Class<?> aClass) {
            return FromCollectCompositeFactPatternWidgetTest.this.listBox;
        }
    }
}

