/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerSelectorFilter;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.TextBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class RuleModellerSelectorFilterTest {
    private static final String FILTER = "filter";
    @Mock
    private Consumer<String> filterChangeConsumer;
    @Mock
    private KeyDownEvent keyDownEvent;
    @Mock
    private ClickEvent clickEvent;
    @GwtMock
    private TextBox txtSearch;
    @GwtMock
    private Button btnSearch;
    @Captor
    private ArgumentCaptor<KeyDownHandler> keyDownHandlerArgumentCaptor;
    @Captor
    private ArgumentCaptor<ClickHandler> clickHandlerArgumentCaptor;
    private RuleModellerSelectorFilter widget;

    @Before
    public void setup() {
        this.widget = new RuleModellerSelectorFilter();
        this.widget.setFilterChangeConsumer(this.filterChangeConsumer);
        Mockito.when((Object)this.txtSearch.getText()).thenReturn((Object)FILTER);
    }

    @Test
    public void testKeyDownEvent_KeyEnter() {
        ((TextBox)Mockito.verify((Object)this.txtSearch)).addKeyDownHandler((KeyDownHandler)this.keyDownHandlerArgumentCaptor.capture());
        KeyDownHandler keyDownHandler = (KeyDownHandler)this.keyDownHandlerArgumentCaptor.getValue();
        Mockito.when((Object)this.keyDownEvent.getNativeKeyCode()).thenReturn((Object)13);
        keyDownHandler.onKeyDown(this.keyDownEvent);
        ((Consumer)Mockito.verify(this.filterChangeConsumer)).accept(FILTER);
    }

    @Test
    public void testKeyDownEvent_KeyOther() {
        ((TextBox)Mockito.verify((Object)this.txtSearch)).addKeyDownHandler((KeyDownHandler)this.keyDownHandlerArgumentCaptor.capture());
        KeyDownHandler keyDownHandler = (KeyDownHandler)this.keyDownHandlerArgumentCaptor.getValue();
        Mockito.when((Object)this.keyDownEvent.getNativeKeyCode()).thenReturn((Object)65);
        keyDownHandler.onKeyDown(this.keyDownEvent);
        ((Consumer)Mockito.verify(this.filterChangeConsumer, (VerificationMode)Mockito.never())).accept(Matchers.anyString());
    }

    @Test
    public void testSearchButtonClick() {
        ((Button)Mockito.verify((Object)this.btnSearch)).addClickHandler((ClickHandler)this.clickHandlerArgumentCaptor.capture());
        ClickHandler clickHandler = (ClickHandler)this.clickHandlerArgumentCaptor.getValue();
        clickHandler.onClick(this.clickEvent);
        ((Consumer)Mockito.verify(this.filterChangeConsumer)).accept(FILTER);
    }

    @Test
    public void testGetFilterText() {
        Assertions.assertThat((String)this.widget.getFilterText()).isEqualTo(FILTER);
    }
}

