/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.drools.workbench.screens.guided.rule.client.editor.TemplateKeyTextBox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class TemplateKeyTextBoxTest {
    private TemplateKeyTextBox textBox;

    @Before
    public void setup() {
        this.textBox = new TemplateKeyTextBox();
    }

    @Test
    public void checkValidationForLostFocus() {
        this.assertions(Assertion.trueForOnLostFocus("$1"), Assertion.trueForOnLostFocus("$a"), Assertion.trueForOnLostFocus("a"), Assertion.falseForOnLostFocus("$"), Assertion.falseForOnLostFocus("1"));
    }

    @Test
    public void checkValidationForKeyboardEntry() {
        this.assertions(Assertion.trueForKeyboardEntry("$"), Assertion.trueForKeyboardEntry("$1"), Assertion.trueForKeyboardEntry("$a"), Assertion.trueForKeyboardEntry("a"), Assertion.falseForKeyboardEntry("1"));
    }

    private void assertions(Assertion ... assertions) {
        List<Assertion> tests = Arrays.asList(assertions);
        tests.stream().filter(a -> a.assertion).forEach(a -> Assert.assertTrue((boolean)this.textBox.isValidValue(a.value, a.isOnFocusLost)));
        tests.stream().filter(a -> !a.assertion).forEach(a -> Assert.assertFalse((boolean)this.textBox.isValidValue(a.value, a.isOnFocusLost)));
    }

    private static class Assertion {
        String value;
        boolean isOnFocusLost;
        boolean assertion;

        private Assertion() {
        }

        static Assertion trueForOnLostFocus(String value) {
            Assertion assertion = new Assertion();
            assertion.value = value;
            assertion.isOnFocusLost = true;
            assertion.assertion = true;
            return assertion;
        }

        static Assertion falseForOnLostFocus(String value) {
            Assertion assertion = new Assertion();
            assertion.value = value;
            assertion.isOnFocusLost = true;
            assertion.assertion = false;
            return assertion;
        }

        static Assertion trueForKeyboardEntry(String value) {
            Assertion assertion = new Assertion();
            assertion.value = value;
            assertion.isOnFocusLost = false;
            assertion.assertion = true;
            return assertion;
        }

        static Assertion falseForKeyboardEntry(String value) {
            Assertion assertion = new Assertion();
            assertion.value = value;
            assertion.isOnFocusLost = false;
            assertion.assertion = false;
            return assertion;
        }
    }
}

