/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget.operator;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.ConstraintValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.OperatorSelection;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.widget.FactPatternWidget;
import org.drools.workbench.screens.guided.rule.client.widget.operator.SingleFieldConstraintOperatorSelector;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.OperatorsOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.i18n.HumanReadableConstants;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;

@WithClassesToStub(value={CEPOperatorsDropdown.class, DateTimeFormat.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class SingleFieldConstraintOperatorSelectorTest {
    @Mock
    private SingleFieldConstraint constraint;
    @Mock
    private ConstraintValueEditor constraintValueEditor;
    @Mock
    private FlexTable wrapper;
    private final int rowIndex = 123;
    private final int columnIndex = 456;
    @Mock
    private FactPatternWidget parent;
    @Mock
    private HorizontalPanel placeholderForDropdown;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private Function<SingleFieldConstraint, ConstraintValueEditor> constraintValueEditorProducer;
    @Captor
    private ArgumentCaptor<Callback<String[]>> operatorsCallbackCaptor;
    @Captor
    private ArgumentCaptor<ValueChangeHandler<OperatorSelection>> operatorChangeHandlerCaptor;
    @Mock
    private CEPOperatorsDropdown operatorsDropdown;
    @Mock
    private OperatorSelection operatorSelection;
    @Mock
    private ValueChangeEvent<OperatorSelection> operatorValueChangeEvent;
    private SingleFieldConstraintOperatorSelector testedSelector;

    @Before
    public void setUp() throws Exception {
        this.testedSelector = (SingleFieldConstraintOperatorSelector)Mockito.spy((Object)new SingleFieldConstraintOperatorSelector());
    }

    @Test
    public void testOperatorNotChanged() throws Exception {
        String selectedOperator = "==";
        String selectedOperatorDisplayText = HumanReadableConstants.INSTANCE.isEqualTo();
        String originalOperator = "==";
        String constraintValue = null;
        this.invokeHandlers("==", selectedOperatorDisplayText, "==", constraintValue);
        ((SingleFieldConstraint)Mockito.verify((Object)this.constraint, (VerificationMode)Mockito.never())).setOperator(Matchers.anyString());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.constraintValueEditor});
    }

    @Test
    public void testNothingSelected() throws Exception {
        String selectedOperator = "";
        String selectedOperatorDisplayText = "";
        String originalOperator = "==";
        String constraintValue = null;
        this.invokeHandlers("", "", "==", constraintValue);
        ((SingleFieldConstraint)Mockito.verify((Object)this.constraint)).setOperator(null);
        ((ConstraintValueEditor)Mockito.verify((Object)this.constraintValueEditor, (VerificationMode)Mockito.never())).showError();
        ((ConstraintValueEditor)Mockito.verify((Object)this.constraintValueEditor)).setVisible(false);
    }

    @Test
    public void testNewOperatorSelectedAndValueNeeded() throws Exception {
        String selectedOperator = "!=";
        String selectedOperatorDisplayText = HumanReadableConstants.INSTANCE.isNotEqualTo();
        String originalOperator = "==";
        String constraintValue = null;
        this.invokeHandlers("!=", selectedOperatorDisplayText, "==", constraintValue);
        ((SingleFieldConstraint)Mockito.verify((Object)this.constraint)).setOperator("!=");
        ((ConstraintValueEditor)Mockito.verify((Object)this.constraintValueEditor)).showError();
        ((ConstraintValueEditor)Mockito.verify((Object)this.constraintValueEditor)).setVisible(true);
    }

    @Test
    public void testNewOperatorSelectedAndValuePresent() throws Exception {
        String selectedOperator = "!=";
        String selectedOperatorDisplayText = HumanReadableConstants.INSTANCE.isNotEqualTo();
        String originalOperator = "==";
        String constraintValue = "123";
        this.invokeHandlers("!=", selectedOperatorDisplayText, "==", "123");
        ((SingleFieldConstraint)Mockito.verify((Object)this.constraint)).setOperator("!=");
        ((ConstraintValueEditor)Mockito.verify((Object)this.constraintValueEditor)).hideError();
        ((ConstraintValueEditor)Mockito.verify((Object)this.constraintValueEditor)).setVisible(true);
    }

    @Test
    public void testNewOperatorSelectedButValueNotNeeded() throws Exception {
        String selectedOperator = "!= null";
        String selectedOperatorDisplayText = HumanReadableConstants.INSTANCE.isNotEqualToNull();
        String originalOperator = "==";
        String constraintValue = "";
        this.invokeHandlers("!= null", selectedOperatorDisplayText, "==", "");
        ((SingleFieldConstraint)Mockito.verify((Object)this.constraint)).setOperator("!= null");
        ((ConstraintValueEditor)Mockito.verify((Object)this.constraintValueEditor)).hideError();
        ((ConstraintValueEditor)Mockito.verify((Object)this.constraintValueEditor)).setVisible(false);
    }

    private void invokeHandlers(String selectedOperator, String selectedOperatorDisplayText, String originalOperator, String constraintValue) {
        String factType = "Person";
        String fieldName = "age";
        Mockito.when((Object)this.constraint.getFactType()).thenReturn((Object)"Person");
        Mockito.when((Object)this.constraint.getFieldName()).thenReturn((Object)"age");
        Mockito.when((Object)this.constraint.getOperator()).thenReturn((Object)originalOperator);
        Mockito.when((Object)this.constraint.getValue()).thenReturn((Object)constraintValue);
        Mockito.when((Object)this.testedSelector.getNewOperatorDropdown(OperatorsOracle.STANDARD_OPERATORS, this.constraint)).thenReturn((Object)this.operatorsDropdown);
        Mockito.when((Object)((OperatorSelection)this.operatorValueChangeEvent.getValue())).thenReturn((Object)this.operatorSelection);
        Mockito.when((Object)this.operatorSelection.getValue()).thenReturn((Object)selectedOperator);
        Mockito.when((Object)this.operatorSelection.getDisplayText()).thenReturn((Object)selectedOperatorDisplayText);
        Mockito.when((Object)this.wrapper.getWidget(123, 456)).thenReturn((Object)this.constraintValueEditor);
        this.testedSelector.configure(this.constraint, () -> this.constraintValueEditor, this.constraintValueEditorProducer, this.parent, this.placeholderForDropdown, this.wrapper, 123, 456, this.oracle);
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle)).getOperatorCompletions((String)Matchers.eq((Object)"Person"), (String)Matchers.eq((Object)"age"), (Callback)this.operatorsCallbackCaptor.capture());
        ((Callback)this.operatorsCallbackCaptor.getValue()).callback((Object)OperatorsOracle.STANDARD_OPERATORS);
        ((HorizontalPanel)Mockito.verify((Object)this.placeholderForDropdown)).add((Widget)this.operatorsDropdown);
        ((CEPOperatorsDropdown)Mockito.verify((Object)this.operatorsDropdown)).addPlaceholder(GuidedRuleEditorResources.CONSTANTS.pleaseChoose(), "");
        ((CEPOperatorsDropdown)Mockito.verify((Object)this.operatorsDropdown)).addValueChangeHandler((ValueChangeHandler)this.operatorChangeHandlerCaptor.capture());
        ((ValueChangeHandler)this.operatorChangeHandlerCaptor.getValue()).onValueChange(this.operatorValueChangeEvent);
    }

    @Test
    public void testIsWidgetForValueNeededIsNull() throws Exception {
        String operator = HumanReadableConstants.INSTANCE.isEqualToNull();
        Assertions.assertThat((boolean)SingleFieldConstraintOperatorSelector.isWidgetForValueNeeded((String)operator)).isFalse();
    }

    @Test
    public void testIsWidgetForValueNeededIsNotNull() throws Exception {
        String operator = HumanReadableConstants.INSTANCE.isNotEqualToNull();
        Assertions.assertThat((boolean)SingleFieldConstraintOperatorSelector.isWidgetForValueNeeded((String)operator)).isFalse();
    }

    @Test
    public void testIsWidgetForValueNeededEmpty() throws Exception {
        String operator = "";
        Assertions.assertThat((boolean)SingleFieldConstraintOperatorSelector.isWidgetForValueNeeded((String)"")).isFalse();
    }

    @Test
    public void testIsWidgetForValueNeededIsEqualtTo() throws Exception {
        String operator = HumanReadableConstants.INSTANCE.isEqualTo();
        Assertions.assertThat((boolean)SingleFieldConstraintOperatorSelector.isWidgetForValueNeeded((String)operator)).isTrue();
    }

    @Test
    public void testIsValueMissingOne() throws Exception {
        String operator = "==";
        String value = "";
        Assertions.assertThat((boolean)SingleFieldConstraintOperatorSelector.isValueMissing((String)"==", (String)"")).isTrue();
    }

    @Test
    public void testIsValueMissingTwo() throws Exception {
        String operator = "==";
        String value = "123";
        Assertions.assertThat((boolean)SingleFieldConstraintOperatorSelector.isValueMissing((String)"==", (String)"123")).isFalse();
    }

    @Test
    public void testIsValueMissingThree() throws Exception {
        String operator = "== null";
        String value = "";
        Assertions.assertThat((boolean)SingleFieldConstraintOperatorSelector.isValueMissing((String)"== null", (String)"")).isFalse();
    }

    @Test
    public void testIsValueMissingFour() throws Exception {
        String operator = "== null";
        String value = "123";
        Assertions.assertThat((boolean)SingleFieldConstraintOperatorSelector.isValueMissing((String)"== null", (String)"123")).isFalse();
    }
}

