/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.datamodel.rule.BaseSingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.editor.util.ConstraintValueEditorHelper;
import org.drools.workbench.screens.guided.rule.client.util.ModelFieldUtil;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.validation.client.dynamic.DynamicValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DropDownData;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.OperatorsOracle;
import org.kie.workbench.common.services.datamodel.service.IncrementalDataModelService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ConstraintValueEditorHelperTest {
    private RuleModel model;
    @Mock
    private IncrementalDataModelService service;
    private Caller<IncrementalDataModelService> serviceCaller;
    @Mock
    private Instance<DynamicValidator> validatorInstance;

    @Before
    public void setUp() throws Exception {
        this.model = new RuleModel();
        this.serviceCaller = new CallerMock((Object)this.service);
    }

    @Test
    public void testSimplePattern() throws Exception {
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        FactPattern pattern = new FactPattern();
        pattern.setBoundName("pp");
        pattern.setFactType("House");
        this.model.addLhsItem((IPattern)pattern);
        FactPattern pattern2 = new FactPattern();
        SingleFieldConstraint constraint = new SingleFieldConstraint();
        constraint.setFactType("House");
        constraint.setFieldName("this");
        constraint.setFieldName("org.mortgages.House");
        pattern2.addConstraint((FieldConstraint)constraint);
        this.model.addLhsItem((IPattern)pattern);
        Mockito.when((Object)oracle.getFieldClassName("House", "this")).thenReturn((Object)"org.mortgages.House");
        ConstraintValueEditorHelper helper = new ConstraintValueEditorHelper(this.model, oracle, "House", "this", (BaseSingleFieldConstraint)constraint, "House", new DropDownData());
        helper.isApplicableBindingsInScope("pp", (Callback)new Callback<Boolean>(){

            public void callback(Boolean result) {
                Assert.assertTrue((boolean)result);
            }
        });
    }

    @Test
    public void testSimpleField() throws Exception {
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        FactPattern pattern = new FactPattern();
        SingleFieldConstraint constraint = new SingleFieldConstraint();
        constraint.setFieldBinding("pp");
        constraint.setFactType("House");
        constraint.setFieldName("parent");
        constraint.setFieldType("org.mortgages.Parent");
        pattern.addConstraint((FieldConstraint)constraint);
        this.model.addLhsItem((IPattern)pattern);
        Mockito.when((Object)oracle.getFieldClassName("House", "parent")).thenReturn((Object)"org.mortgages.Parent");
        ConstraintValueEditorHelper helper = new ConstraintValueEditorHelper(this.model, oracle, "House", "parent", (BaseSingleFieldConstraint)constraint, "Parent", new DropDownData());
        helper.isApplicableBindingsInScope("pp", (Callback)new Callback<Boolean>(){

            public void callback(Boolean result) {
                Assert.assertTrue((boolean)result);
            }
        });
    }

    @Test
    public void testEvents_BothTypesAreEvents() throws Exception {
        AsyncPackageDataModelOracleImpl oracle = new AsyncPackageDataModelOracleImpl(this.serviceCaller, this.validatorInstance);
        oracle.setPackageName("org.test");
        oracle.addModelFields((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("org.test.Event1", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"org.test.Event1")});
                this.put("org.test.Event2", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"org.test.Event2")});
            }
        });
        oracle.addEventTypes((Map)new HashMap<String, Boolean>(){
            {
                this.put("org.test.Event1", true);
                this.put("org.test.Event2", true);
            }
        });
        oracle.filter();
        FactPattern pattern1 = new FactPattern();
        pattern1.setFactType("Event1");
        pattern1.setBoundName("$e");
        SingleFieldConstraint constraint = new SingleFieldConstraint();
        constraint.setFactType("Event1");
        constraint.setFieldName("this");
        constraint.setFieldType("Event1");
        constraint.setOperator(OperatorsOracle.SIMPLE_CEP_OPERATORS[0]);
        pattern1.addConstraint((FieldConstraint)constraint);
        this.model.addLhsItem((IPattern)pattern1);
        ConstraintValueEditorHelper helper = new ConstraintValueEditorHelper(this.model, (AsyncPackageDataModelOracle)oracle, "Event2", "this", (BaseSingleFieldConstraint)constraint, "Event2", new DropDownData());
        helper.isApplicableBindingsInScope("$e", (Callback)new Callback<Boolean>(){

            public void callback(Boolean result) {
                Assert.assertTrue((boolean)result);
            }
        });
    }

    @Test
    public void testEvents_BoundTypeIsEvent() throws Exception {
        AsyncPackageDataModelOracleImpl oracle = new AsyncPackageDataModelOracleImpl(this.serviceCaller, this.validatorInstance);
        oracle.setPackageName("org.test");
        oracle.addModelFields((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("org.test.Event1", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"org.test.Event1")});
                this.put("org.test.Event2", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"org.test.Event2")});
            }
        });
        oracle.addEventTypes((Map)new HashMap<String, Boolean>(){
            {
                this.put("org.test.Event1", true);
                this.put("org.test.Event2", false);
            }
        });
        oracle.addSuperTypes((Map)new HashMap<String, List<String>>(){
            {
                this.put("org.test.Event1", Collections.EMPTY_LIST);
                this.put("org.test.Event2", Collections.EMPTY_LIST);
            }
        });
        oracle.filter();
        FactPattern pattern1 = new FactPattern();
        pattern1.setFactType("Event1");
        pattern1.setBoundName("$e");
        SingleFieldConstraint constraint = new SingleFieldConstraint();
        constraint.setFactType("Event1");
        constraint.setFieldName("this");
        constraint.setFieldType("Event1");
        constraint.setOperator(OperatorsOracle.SIMPLE_CEP_OPERATORS[0]);
        pattern1.addConstraint((FieldConstraint)constraint);
        this.model.addLhsItem((IPattern)pattern1);
        ConstraintValueEditorHelper helper = new ConstraintValueEditorHelper(this.model, (AsyncPackageDataModelOracle)oracle, "Event2", "this", (BaseSingleFieldConstraint)constraint, "Event2", new DropDownData());
        helper.isApplicableBindingsInScope("$e", (Callback)new Callback<Boolean>(){

            public void callback(Boolean result) {
                Assert.assertFalse((boolean)result);
            }
        });
    }

    @Test
    public void testEvents_BoundTypeIsNotEvent() throws Exception {
        AsyncPackageDataModelOracleImpl oracle = new AsyncPackageDataModelOracleImpl(this.serviceCaller, this.validatorInstance);
        oracle.setPackageName("org.test");
        oracle.addModelFields((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("org.test.Event1", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"org.test.Event1")});
                this.put("org.test.Event2", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"org.test.Event2")});
            }
        });
        oracle.addEventTypes((Map)new HashMap<String, Boolean>(){
            {
                this.put("org.test.Event1", false);
                this.put("org.test.Event2", true);
            }
        });
        oracle.addSuperTypes((Map)new HashMap<String, List<String>>(){
            {
                this.put("org.test.Event1", Collections.EMPTY_LIST);
                this.put("org.test.Event2", Collections.EMPTY_LIST);
            }
        });
        oracle.filter();
        FactPattern pattern1 = new FactPattern();
        pattern1.setFactType("Event1");
        pattern1.setBoundName("$e");
        SingleFieldConstraint constraint = new SingleFieldConstraint();
        constraint.setFactType("Event1");
        constraint.setFieldName("this");
        constraint.setFieldType("Event1");
        constraint.setOperator(OperatorsOracle.SIMPLE_CEP_OPERATORS[0]);
        pattern1.addConstraint((FieldConstraint)constraint);
        this.model.addLhsItem((IPattern)pattern1);
        ConstraintValueEditorHelper helper = new ConstraintValueEditorHelper(this.model, (AsyncPackageDataModelOracle)oracle, "Event2", "this", (BaseSingleFieldConstraint)constraint, "Event2", new DropDownData());
        helper.isApplicableBindingsInScope("$e", (Callback)new Callback<Boolean>(){

            public void callback(Boolean result) {
                Assert.assertFalse((boolean)result);
            }
        });
    }

    @Test
    public void isEnumEquivalentBothNull() throws Exception {
        DropDownData dropDownData = (DropDownData)Mockito.mock(DropDownData.class);
        ((DropDownData)Mockito.doReturn(null).when((Object)dropDownData)).getFixedList();
        Assertions.assertThat((boolean)ConstraintValueEditorHelper.isEnumEquivalent(null, (DropDownData)dropDownData)).isTrue();
    }

    @Test
    public void isEnumEquivalentFirstNull() throws Exception {
        DropDownData dropDownData = (DropDownData)Mockito.mock(DropDownData.class);
        ((DropDownData)Mockito.doReturn((Object)new String[0]).when((Object)dropDownData)).getFixedList();
        Assertions.assertThat((boolean)ConstraintValueEditorHelper.isEnumEquivalent(null, (DropDownData)dropDownData)).isFalse();
    }

    @Test
    public void isEnumEquivalentSecondNull() throws Exception {
        DropDownData dropDownData = (DropDownData)Mockito.mock(DropDownData.class);
        ((DropDownData)Mockito.doReturn(null).when((Object)dropDownData)).getFixedList();
        Assertions.assertThat((boolean)ConstraintValueEditorHelper.isEnumEquivalent((String[])new String[0], (DropDownData)dropDownData)).isFalse();
    }

    @Test
    public void isEnumEquivalentDifferentLength() throws Exception {
        DropDownData dropDownData = (DropDownData)Mockito.mock(DropDownData.class);
        ((DropDownData)Mockito.doReturn((Object)new String[0]).when((Object)dropDownData)).getFixedList();
        Assertions.assertThat((boolean)ConstraintValueEditorHelper.isEnumEquivalent((String[])new String[1], (DropDownData)dropDownData)).isFalse();
    }

    @Test
    public void isEnumEquivalentDifferentContent() throws Exception {
        DropDownData dropDownData = (DropDownData)Mockito.mock(DropDownData.class);
        ((DropDownData)Mockito.doReturn((Object)new String[]{"a"}).when((Object)dropDownData)).getFixedList();
        Assertions.assertThat((boolean)ConstraintValueEditorHelper.isEnumEquivalent((String[])new String[]{"b"}, (DropDownData)dropDownData)).isFalse();
    }

    @Test
    public void isEnumEquivalentSameContent() throws Exception {
        DropDownData dropDownData = (DropDownData)Mockito.mock(DropDownData.class);
        ((DropDownData)Mockito.doReturn((Object)new String[]{"a", "b", "c"}).when((Object)dropDownData)).getFixedList();
        Assertions.assertThat((boolean)ConstraintValueEditorHelper.isEnumEquivalent((String[])new String[]{"a", "b", "c"}, (DropDownData)dropDownData)).isTrue();
    }
}

