/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Collection;
import java.util.Collections;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.ModellerWidgetFactory;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerActionSelectorPopup;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.ruleselector.RuleSelector;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={GuidedRuleEditorImages508.class, FlexTable.class})
public class RuleModellerTest {
    private RuleModel model;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private ModellerWidgetFactory widgetFactory;
    @Mock
    private EventBus eventBus;
    @Mock
    private RuleSelector ruleSelector;
    @Mock
    private RuleModellerActionSelectorPopup actionSelectorPopup;
    @Mock
    private RuleModellerActionPlugin actionPlugin;
    final Collection<RuleModellerActionPlugin> actionPlugins;
    private RuleModeller ruleModeller;

    public RuleModellerTest() {
        this.actionPlugins = Collections.singleton(this.actionPlugin);
    }

    @Before
    public void setUp() throws Exception {
        this.model = new RuleModel();
        GwtMockito.useProviderForType(RuleSelector.class, aClass -> this.ruleSelector);
        this.ruleModeller = (RuleModeller)Mockito.spy((Object)new RuleModeller(this.model, this.actionPlugins, this.oracle, this.widgetFactory, this.eventBus, false, false));
    }

    @Test
    public void testSetRuleNamesForPackage() throws Exception {
        this.model.name = "rule 1";
        this.ruleModeller.setRuleNamesForPackage(Collections.singleton("rule 2"));
        ((RuleSelector)Mockito.verify((Object)this.ruleSelector)).setRuleNames(Collections.singleton("rule 2"), "rule 1");
    }

    @Test
    public void testShowActionSelector() throws Exception {
        Integer position = 123;
        ((RuleModeller)Mockito.doReturn((Object)this.actionSelectorPopup).when((Object)this.ruleModeller)).ruleModellerActionSelectorPopup((Integer)Matchers.eq((Object)position), (Collection)Matchers.eq(this.actionPlugins));
        this.ruleModeller.showActionSelector(position);
        ((RuleModellerActionSelectorPopup)Mockito.verify((Object)this.actionSelectorPopup)).show();
    }
}

