/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget.operator;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.drools.workbench.models.datamodel.rule.HasParameterizedOperator;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.ConstraintValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.OperatorSelection;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.widget.FactPatternWidget;
import org.kie.soup.project.datamodel.oracle.OperatorsOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.i18n.HumanReadableConstants;

public class SingleFieldConstraintOperatorSelector {
    private SingleFieldConstraint constraint;
    private Supplier<ConstraintValueEditor> constraintValueEditor;
    private FlexTable constraintValueEditorWrapper;
    private int constraintValueEditorRowIndex;
    private int constraintValueEditorColumnIndex;
    private FactPatternWidget parent;
    private HorizontalPanel placeholderForDropdown;
    private AsyncPackageDataModelOracle oracle;
    private Function<SingleFieldConstraint, ConstraintValueEditor> constraintValueEditorProducer;

    public void configure(SingleFieldConstraint constraint, Supplier<ConstraintValueEditor> constraintValueEditor, Function<SingleFieldConstraint, ConstraintValueEditor> constraintValueEditorProducer, FactPatternWidget parent, HorizontalPanel placeholderForDropdown, FlexTable constraintValueEditorWrapper, int constraintValueEditorRowIndex, int constraintValueEditorColumnIndex, AsyncPackageDataModelOracle oracle) {
        String fieldName;
        String factType;
        this.constraint = constraint;
        this.constraintValueEditor = constraintValueEditor;
        this.constraintValueEditorProducer = constraintValueEditorProducer;
        this.parent = parent;
        this.placeholderForDropdown = placeholderForDropdown;
        this.constraintValueEditorWrapper = constraintValueEditorWrapper;
        this.constraintValueEditorRowIndex = constraintValueEditorRowIndex;
        this.constraintValueEditorColumnIndex = constraintValueEditorColumnIndex;
        this.oracle = oracle;
        if (constraint instanceof SingleFieldConstraintEBLeftSide) {
            SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)constraint;
            factType = sfexp.getExpressionLeftSide().getPreviousClassType();
            if (factType == null) {
                factType = sfexp.getExpressionLeftSide().getClassType();
            }
            fieldName = sfexp.getExpressionLeftSide().getFieldName();
        } else {
            factType = constraint.getFactType();
            fieldName = constraint.getFieldName();
        }
        oracle.getOperatorCompletions(factType, fieldName, operators -> {
            CEPOperatorsDropdown operatorsDropdown = this.getNewOperatorDropdown((String[])operators, constraint);
            operatorsDropdown.addPlaceholder(GuidedRuleEditorResources.CONSTANTS.pleaseChoose(), "");
            placeholderForDropdown.add((Widget)operatorsDropdown);
            operatorsDropdown.addValueChangeHandler((ValueChangeHandler<OperatorSelection>)((ValueChangeHandler)event -> this.onDropDownValueChanged((ValueChangeEvent<OperatorSelection>)event)));
        });
    }

    private void onDropDownValueChanged(ValueChangeEvent<OperatorSelection> event) {
        this.parent.setModified(true);
        String selected = ((OperatorSelection)event.getValue()).getValue();
        String selectedText = ((OperatorSelection)event.getValue()).getDisplayText();
        String originalOperator = this.constraint.getOperator();
        if (Objects.equals(selected, this.constraint.getOperator())) {
            return;
        }
        if (Objects.equals(selected, "")) {
            this.constraint.setOperator(null);
        } else {
            this.constraint.setOperator(selected);
        }
        if (SingleFieldConstraintOperatorSelector.isValueMissing(selected, this.constraint.getValue())) {
            this.constraintValueEditor.get().showError();
        } else {
            this.constraintValueEditor.get().hideError();
        }
        if (this.constraintValueEditorWrapper != null) {
            if (SingleFieldConstraintOperatorSelector.isWidgetForValueNeeded(selectedText)) {
                this.constraintValueEditorWrapper.getWidget(this.constraintValueEditorRowIndex, this.constraintValueEditorColumnIndex).setVisible(true);
            } else {
                this.constraintValueEditorWrapper.getWidget(this.constraintValueEditorRowIndex, this.constraintValueEditorColumnIndex).setVisible(false);
            }
        }
        if (OperatorsOracle.operatorRequiresList((String)selected) != OperatorsOracle.operatorRequiresList((String)originalOperator)) {
            String[] oldValueList;
            if (!OperatorsOracle.operatorRequiresList((String)selected) && (oldValueList = this.constraint.getValue().split(",")).length > 0) {
                this.constraint.setValue(oldValueList[0]);
            }
            this.constraintValueEditorWrapper.setWidget(this.constraintValueEditorRowIndex, this.constraintValueEditorColumnIndex, (Widget)this.constraintValueEditorProducer.apply(this.constraint));
        }
    }

    CEPOperatorsDropdown getNewOperatorDropdown(String[] operators, SingleFieldConstraint constraint) {
        return new CEPOperatorsDropdown(operators, (HasParameterizedOperator)constraint);
    }

    static boolean isWidgetForValueNeeded(String constraintOperator) {
        return constraintOperator != null && !constraintOperator.isEmpty() && !Objects.equals(constraintOperator, HumanReadableConstants.INSTANCE.isEqualToNull()) && !Objects.equals(constraintOperator, HumanReadableConstants.INSTANCE.isNotEqualToNull());
    }

    static boolean isValueMissing(String constraintOperator, String constraintValue) {
        return OperatorsOracle.isValueRequired((String)constraintOperator) && (constraintValue == null || constraintValue.isEmpty());
    }
}

