/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.datamodeller.driver.FileChangeDescriptor;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverListener;
import org.kie.workbench.common.services.datamodeller.util.FileHashingUtils;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RequestScoped
public class ProjectResourceDriverListener
implements ModelDriverListener {
    private static final Logger logger = LoggerFactory.getLogger(ProjectResourceDriverListener.class);
    @Inject
    private KieProjectService projectService;
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    private CommentedOption option;
    private Project currentProject;
    private Package defaultPackage;
    List<FileChangeDescriptor> fileChanges = new ArrayList<FileChangeDescriptor>();

    public void setCurrentProject(Project currentProject) {
        this.currentProject = currentProject;
    }

    public void setOption(CommentedOption option) {
        this.option = option;
    }

    public void init() throws Exception {
        this.defaultPackage = this.projectService.resolveDefaultPackage(this.currentProject);
    }

    public void assetGenerated(String fileName, String content) {
        Path subDirPath = Paths.convert((org.uberfire.backend.vfs.Path)this.defaultPackage.getPackageMainSrcPath());
        Package subPackage = this.defaultPackage;
        int index = fileName.lastIndexOf("/");
        if (index == 0) {
            fileName = fileName.substring(1, fileName.length());
        } else if (index > 0) {
            String dirNamesPath = fileName.substring(0, index);
            fileName = fileName.substring(index + 1, fileName.length());
            StringTokenizer dirNames = new StringTokenizer(dirNamesPath, "/");
            while (dirNames.hasMoreElements()) {
                String subDirName = dirNames.nextToken();
                if (!this.ioService.exists(subDirPath = subDirPath.resolve(subDirName))) {
                    subPackage = this.projectService.newPackage(subPackage, subDirName);
                    continue;
                }
                subPackage = this.projectService.resolvePackage(Paths.convert((Path)subDirPath));
            }
        }
        Path destFilePath = subDirPath.resolve(fileName);
        boolean exists = this.ioService.exists(destFilePath);
        content = content != null ? content.trim() : null;
        String hashedContent = FileHashingUtils.setFileHashValue((String)content);
        this.ioService.write(destFilePath, hashedContent, new OpenOption[]{this.option});
        if (!exists) {
            if (logger.isDebugEnabled()) {
                logger.debug("Genertion listener created a new file: " + destFilePath);
            }
            this.fileChanges.add(new FileChangeDescriptor(destFilePath, 0));
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Generation listener modified file: " + destFilePath);
            }
            this.fileChanges.add(new FileChangeDescriptor(destFilePath, 2));
        }
    }

    public List<FileChangeDescriptor> getFileChanges() {
        return this.fileChanges;
    }
}

