/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.guvnor.common.services.builder.IncrementalBuilderExecutorManager;
import org.guvnor.common.services.builder.IncrementalBuilderExecutorManagerFactory;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class IncrementalBuilderExecutorManagerFactoryImpl
implements IncrementalBuilderExecutorManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalBuilderExecutorManagerFactoryImpl.class);
    private final boolean USE_EXECUTOR_SAFE_MODE = Boolean.parseBoolean(System.getProperty("org.uberfire.async.executor.safemode", "false"));
    @Inject
    private ProjectService<? extends Project> projectService;
    @Inject
    private BuildService buildService;
    @Inject
    private Event<BuildResults> buildResultsEvent;
    @Inject
    private Event<IncrementalBuildResults> incrementalBuildResultsEvent;
    private IncrementalBuilderExecutorManager executorManager = null;

    @Override
    public synchronized IncrementalBuilderExecutorManager getExecutorManager() {
        if (this.executorManager == null) {
            IncrementalBuilderExecutorManager _executorManager = null;
            if (!this.USE_EXECUTOR_SAFE_MODE) {
                try {
                    _executorManager = (IncrementalBuilderExecutorManager)InitialContext.doLookup("java:module/IncrementalBuilderExecutorManager");
                }
                catch (Exception e) {
                    LOG.warn("Unable to instantiate EJB Asynchronous Bean. Falling back to Executors' CachedThreadPool.", (Throwable)e);
                }
            } else {
                LOG.info("Use of to Executors' CachedThreadPool has been requested; overriding container provisioning.");
            }
            if (_executorManager == null) {
                this.executorManager = new IncrementalBuilderExecutorManager();
                this.executorManager.setServices(this.projectService, this.buildService, this.buildResultsEvent, this.incrementalBuildResultsEvent);
            } else {
                this.executorManager = _executorManager;
            }
        }
        return this.executorManager;
    }
}

