/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.indexing;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.compiler.DrlExprParser;
import org.drools.compiler.lang.descr.AccessorDescr;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.ActionDescr;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AtomicExprDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.CollectDescr;
import org.drools.compiler.lang.descr.ConstraintConnectiveDescr;
import org.drools.compiler.lang.descr.DeclarativeInvokerDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.FactTemplateDescr;
import org.drools.compiler.lang.descr.FieldConstraintDescr;
import org.drools.compiler.lang.descr.FieldTemplateDescr;
import org.drools.compiler.lang.descr.ForallDescr;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.LiteralRestrictionDescr;
import org.drools.compiler.lang.descr.MVELExprDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.OrDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.PredicateDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RelationalExprDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.model.index.Rule;
import org.kie.workbench.common.services.refactoring.model.index.RuleAttribute;
import org.kie.workbench.common.services.refactoring.model.index.Type;
import org.kie.workbench.common.services.refactoring.model.index.TypeField;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueFieldIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueRuleAttributeIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueRuleAttributeValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueRuleIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;

public class PackageDescrIndexVisitor {
    private final ProjectDataModelOracle dmo;
    private final DefaultIndexBuilder builder;
    private final PackageDescr packageDescr;
    private final PackageDescrIndexVisitorContext context = new PackageDescrIndexVisitorContext();

    public PackageDescrIndexVisitor(ProjectDataModelOracle dmo, DefaultIndexBuilder builder, PackageDescr packageDescr) {
        this.dmo = (ProjectDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.builder = (DefaultIndexBuilder)PortablePreconditions.checkNotNull((String)"builder", (Object)builder);
        this.packageDescr = (PackageDescr)PortablePreconditions.checkNotNull((String)"packageDescr", (Object)packageDescr);
    }

    public Set<Pair<String, String>> visit() {
        this.visit(this.packageDescr);
        return this.builder.build();
    }

    private void visit(Object descr) {
        if (descr instanceof AccessorDescr) {
            this.visit((AccessorDescr)descr);
        } else if (descr instanceof AccumulateDescr) {
            this.visit((AccumulateDescr)descr);
        } else if (descr instanceof ActionDescr) {
            this.visit((ActionDescr)descr);
        } else if (descr instanceof AndDescr) {
            this.visit((AndDescr)descr);
        } else if (descr instanceof AnnotationDescr) {
            this.visit((AnnotationDescr)descr);
        } else if (descr instanceof AtomicExprDescr) {
            this.visit((AtomicExprDescr)descr);
        } else if (descr instanceof AttributeDescr) {
            this.visit((AttributeDescr)descr);
        } else if (descr instanceof BindingDescr) {
            this.visit((BindingDescr)descr);
        } else if (descr instanceof CollectDescr) {
            this.visit((CollectDescr)descr);
        } else if (descr instanceof ConstraintConnectiveDescr) {
            this.visit((ConstraintConnectiveDescr)descr);
        } else if (descr instanceof ExistsDescr) {
            this.visit((ExistsDescr)descr);
        } else if (descr instanceof ExprConstraintDescr) {
            this.visit((ExprConstraintDescr)descr);
        } else if (descr instanceof FactTemplateDescr) {
            this.visit((FactTemplateDescr)descr);
        } else if (descr instanceof FieldConstraintDescr) {
            this.visit((FieldConstraintDescr)descr);
        } else if (descr instanceof FieldTemplateDescr) {
            this.visit((FieldTemplateDescr)descr);
        } else if (descr instanceof ForallDescr) {
            this.visit((ForallDescr)descr);
        } else if (descr instanceof FromDescr) {
            this.visit((FromDescr)descr);
        } else if (descr instanceof FunctionDescr) {
            this.visit((FunctionDescr)descr);
        } else if (descr instanceof FunctionImportDescr) {
            this.visit((FunctionImportDescr)descr);
        } else if (descr instanceof GlobalDescr) {
            this.visit((GlobalDescr)descr);
        } else if (descr instanceof ImportDescr) {
            this.visit((ImportDescr)descr);
        } else if (descr instanceof LiteralRestrictionDescr) {
            this.visit((LiteralRestrictionDescr)descr);
        } else if (descr instanceof MVELExprDescr) {
            this.visit((MVELExprDescr)descr);
        } else if (descr instanceof NotDescr) {
            this.visit((NotDescr)descr);
        } else if (descr instanceof OrDescr) {
            this.visit((OrDescr)descr);
        } else if (descr instanceof PackageDescr) {
            this.visit((PackageDescr)descr);
        } else if (descr instanceof PatternDescr) {
            this.visit((PatternDescr)descr);
        } else if (descr instanceof PredicateDescr) {
            this.visit((PredicateDescr)descr);
        } else if (descr instanceof QueryDescr) {
            this.visit((QueryDescr)descr);
        } else if (descr instanceof RelationalExprDescr) {
            this.visit((RelationalExprDescr)descr);
        } else if (descr instanceof RuleDescr) {
            this.visit((RuleDescr)descr);
        } else if (descr instanceof TypeDeclarationDescr) {
            this.visit((TypeDeclarationDescr)descr);
        } else if (descr instanceof TypeFieldDescr) {
            this.visit((TypeFieldDescr)descr);
        } else if (descr instanceof WindowDeclarationDescr) {
            this.visit((WindowDeclarationDescr)descr);
        }
    }

    protected void visit(AccessorDescr descr) {
        for (DeclarativeInvokerDescr d : descr.getInvokersAsArray()) {
            this.visit(d);
        }
    }

    protected void visit(AccumulateDescr descr) {
        this.visit(descr.getInputPattern());
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(ActionDescr descr) {
    }

    protected void visit(AndDescr descr) {
        for (BaseDescr baseDescr : descr.getDescrs()) {
            this.visit(baseDescr);
        }
    }

    protected void visit(AnnotationDescr descr) {
    }

    protected void visit(AtomicExprDescr descr) {
        String expression = descr.getExpression();
        this.parseExpression(expression);
    }

    private String parseExpression(String expression) {
        String factType = this.context.getCurrentPattern().getObjectType();
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(this.packageDescr, factType);
        while (expression.contains(".")) {
            String fieldName = expression.substring(0, expression.indexOf("."));
            if (this.context.isBoundType(fieldName)) {
                fullyQualifiedClassName = this.context.getBoundType(fieldName);
                expression = expression.substring(expression.indexOf(".") + 1);
                continue;
            }
            expression = expression.substring(expression.indexOf(".") + 1);
            factType = this.addField(fieldName, fullyQualifiedClassName);
            if (factType == null) continue;
            fullyQualifiedClassName = this.getFullyQualifiedClassName(this.packageDescr, factType);
        }
        return this.addField(expression, fullyQualifiedClassName);
    }

    private String addField(String fieldName, String fullyQualifiedClassName) {
        ModelField[] mfs = (ModelField[])this.dmo.getProjectModelFields().get(fullyQualifiedClassName);
        if (mfs != null) {
            for (ModelField mf : mfs) {
                if (!mf.getName().equals(fieldName)) continue;
                this.builder.addGenerator((IndexElementsGenerator)new TypeField(new ValueFieldIndexTerm(fieldName), new ValueTypeIndexTerm(mf.getClassName()), new ValueTypeIndexTerm(fullyQualifiedClassName)));
                return mf.getClassName();
            }
        }
        return null;
    }

    protected void visit(AttributeDescr descr) {
        this.builder.addGenerator((IndexElementsGenerator)new RuleAttribute(new ValueRuleAttributeIndexTerm(descr.getName()), new ValueRuleAttributeValueIndexTerm(descr.getValue())));
    }

    protected void visit(BindingDescr descr) {
        String identifier = descr.getVariable();
        String fullyQualifiedClassName = this.parseExpression(descr.getExpression());
        this.context.addBoundType(identifier, fullyQualifiedClassName);
    }

    protected void visit(CollectDescr descr) {
        this.visit(descr.getInputPattern());
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(ConstraintConnectiveDescr descr) {
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(ExistsDescr descr) {
        for (Object o : descr.getDescrs()) {
            this.visit(o);
        }
    }

    protected void visit(ExprConstraintDescr descr) {
        DrlExprParser parser = new DrlExprParser(LanguageLevelOption.DRL6);
        ConstraintConnectiveDescr result = parser.parse(descr.getExpression());
        this.visit(result);
    }

    protected void visit(FactTemplateDescr descr) {
        for (FieldTemplateDescr d : descr.getFields()) {
            this.visit(d);
        }
    }

    protected void visit(FieldConstraintDescr descr) {
        for (Object o : descr.getRestrictions()) {
            this.visit(o);
        }
    }

    protected void visit(FieldTemplateDescr descr) {
    }

    protected void visit(ForallDescr descr) {
        this.visit(descr.getBasePattern());
        for (BaseDescr o : descr.getDescrs()) {
            this.visit(o);
        }
    }

    protected void visit(FromDescr descr) {
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(FunctionDescr descr) {
    }

    protected void visit(FunctionImportDescr descr) {
    }

    protected void visit(GlobalDescr descr) {
        this.builder.addGenerator((IndexElementsGenerator)new Type(new ValueTypeIndexTerm(this.getFullyQualifiedClassName(this.packageDescr, descr.getType()))));
    }

    protected void visit(ImportDescr descr) {
        this.builder.addGenerator((IndexElementsGenerator)new Type(new ValueTypeIndexTerm(descr.getTarget())));
    }

    protected void visit(LiteralRestrictionDescr descr) {
    }

    protected void visit(MVELExprDescr descr) {
    }

    protected void visit(NotDescr descr) {
        for (Object o : descr.getDescrs()) {
            this.visit(o);
        }
    }

    protected void visit(OrDescr descr) {
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(PackageDescr descr) {
        for (GlobalDescr globalDescr : descr.getGlobals()) {
            this.visit(globalDescr);
        }
        for (RuleDescr ruleDescr : descr.getRules()) {
            this.visit(ruleDescr);
        }
    }

    protected void visit(PatternDescr descr) {
        this.context.startPattern(descr);
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(this.packageDescr, descr.getObjectType());
        if (descr.getIdentifier() != null && !descr.getIdentifier().isEmpty()) {
            this.context.addBoundType(descr.getIdentifier(), fullyQualifiedClassName);
        }
        this.builder.addGenerator((IndexElementsGenerator)new Type(new ValueTypeIndexTerm(fullyQualifiedClassName)));
        this.visit(descr.getConstraint());
        this.context.endPattern();
    }

    protected void visit(PredicateDescr descr) {
    }

    protected void visit(QueryDescr descr) {
        this.visit(descr.getLhs());
    }

    protected void visit(RelationalExprDescr descr) {
        this.visit(descr.getLeft());
        this.visit(descr.getRight());
    }

    protected void visit(RuleDescr descr) {
        this.builder.addGenerator((IndexElementsGenerator)new Rule(new ValueRuleIndexTerm(descr.getName()), descr.getParentName() == null ? null : new ValueRuleIndexTerm(descr.getParentName())));
        for (AttributeDescr d : descr.getAttributes().values()) {
            this.visit(d);
        }
        this.visit(descr.getLhs());
        this.visitConsequence(descr.getConsequence());
        for (Object o : descr.getNamedConsequences().values()) {
            this.visitConsequence(o);
        }
    }

    protected void visitConsequence(Object consequence) {
    }

    protected void visit(TypeDeclarationDescr descr) {
        this.builder.addGenerator((IndexElementsGenerator)new Type(new ValueTypeIndexTerm(this.getFullyQualifiedClassName(this.packageDescr, descr.getTypeName()))));
        if (descr.getSuperTypeName() != null && !descr.getSuperTypeName().isEmpty()) {
            this.builder.addGenerator((IndexElementsGenerator)new Type(new ValueTypeIndexTerm(this.getFullyQualifiedClassName(this.packageDescr, descr.getSuperTypeName()))));
        }
    }

    protected void visit(TypeFieldDescr descr) {
    }

    protected void visit(WindowDeclarationDescr descr) {
        this.visit(descr.getPattern());
    }

    private String getFullyQualifiedClassName(PackageDescr packageDescr, String typeName) {
        if (typeName.contains(".")) {
            return typeName;
        }
        for (ImportDescr importDescr : packageDescr.getImports()) {
            if (!importDescr.getTarget().endsWith(typeName)) continue;
            return importDescr.getTarget();
        }
        return packageDescr.getName() + "." + typeName;
    }

    private static class PackageDescrIndexVisitorContext {
        private Deque<PatternDescr> patterns = new ArrayDeque<PatternDescr>();
        private Map<String, String> boundTypes = new HashMap<String, String>();

        private PackageDescrIndexVisitorContext() {
        }

        void startPattern(PatternDescr descr) {
            this.patterns.add(descr);
        }

        void endPattern() {
            this.patterns.pop();
        }

        PatternDescr getCurrentPattern() {
            return this.patterns.peek();
        }

        void addBoundType(String identifier, String fullyQualifiedClassName) {
            this.boundTypes.put(identifier, fullyQualifiedClassName);
        }

        boolean isBoundType(String identifier) {
            return this.boundTypes.containsKey(identifier);
        }

        String getBoundType(String identifier) {
            return this.boundTypes.get(identifier);
        }
    }
}

