/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQueries;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.TermsCheck;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfig;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexManager;
import org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.search.ClusterSegment;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class RefactoringQueryServiceImpl
implements RefactoringQueryService {
    private LuceneConfig config;
    private NamedQueries namedQueries;
    private PageResponse<RefactoringPageRow> emptyResponse;

    public RefactoringQueryServiceImpl() {
    }

    @Inject
    public RefactoringQueryServiceImpl(@Named(value="luceneConfig") LuceneConfig config, NamedQueries namedQueries) {
        this.config = (LuceneConfig)PortablePreconditions.checkNotNull((String)"config", (Object)config);
        this.namedQueries = (NamedQueries)PortablePreconditions.checkNotNull((String)"namedQueries", (Object)namedQueries);
    }

    @PostConstruct
    public void init() {
        this.emptyResponse = new PageResponse();
        this.emptyResponse.setPageRowList(Collections.emptyList());
        this.emptyResponse.setStartRowIndex(0);
        this.emptyResponse.setTotalRowSize(0);
        this.emptyResponse.setLastPage(true);
        this.emptyResponse.setTotalRowSizeExact(true);
    }

    public Set<String> getQueries() {
        return this.namedQueries.getQueries();
    }

    public Set<IndexTerm> getTerms(String queryName) {
        return this.namedQueries.getTerms(queryName);
    }

    public PageResponse<RefactoringPageRow> query(RefactoringPageRequest request) {
        PortablePreconditions.checkNotNull((String)"request", (Object)request);
        String queryName = (String)PortablePreconditions.checkNotNull((String)"queryName", (Object)request.getQueryName());
        NamedQuery namedQuery = this.namedQueries.findNamedQuery(queryName);
        TermsCheck.checkTermsMatch(request.getQueryTerms(), namedQuery.getTerms());
        Query query = namedQuery.toQuery(request.getQueryTerms(), request.useWildcards());
        if (this.searchHits(query, new ClusterSegment[0]) > 0) {
            int pageSize = request.getPageSize();
            int startIndex = request.getStartRowIndex();
            List<KObject> kObjects = this.search(query, pageSize, startIndex, new ClusterSegment[0]);
            ResponseBuilder responseBuilder = namedQuery.getResponseBuilder();
            return responseBuilder.buildResponse(pageSize, startIndex, kObjects);
        }
        return this.emptyResponse;
    }

    public List<RefactoringPageRow> query(String queryName, Set<ValueIndexTerm> queryTerms, boolean useWildcards) {
        PortablePreconditions.checkNotNull((String)"queryName", (Object)queryName);
        PortablePreconditions.checkNotNull((String)"queryTerms", queryTerms);
        NamedQuery namedQuery = this.namedQueries.findNamedQuery(queryName);
        TermsCheck.checkTermsMatch(queryTerms, namedQuery.getTerms());
        Query query = namedQuery.toQuery(queryTerms, useWildcards);
        int hits = this.searchHits(query, new ClusterSegment[0]);
        if (hits > 0) {
            List<KObject> kObjects = this.search(query, hits, new ClusterSegment[0]);
            ResponseBuilder responseBuilder = namedQuery.getResponseBuilder();
            return responseBuilder.buildResponse(kObjects);
        }
        return Collections.emptyList();
    }

    private int searchHits(Query query, ClusterSegment ... clusterSegments) {
        LuceneIndexManager indexManager = (LuceneIndexManager)this.config.getIndexManager();
        IndexSearcher index = indexManager.getIndexSearcher(clusterSegments);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            index.search(query, (Collector)collector);
            int n = collector.getTotalHits();
            return n;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            indexManager.release(index);
        }
    }

    private List<KObject> search(Query query, int pageSize, int startIndex, ClusterSegment ... clusterSegments) {
        LuceneIndexManager indexManager = (LuceneIndexManager)this.config.getIndexManager();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)((startIndex + 1) * pageSize), (boolean)true);
        IndexSearcher index = indexManager.getIndexSearcher(clusterSegments);
        ArrayList<KObject> result = new ArrayList<KObject>(pageSize);
        try {
            index.search(query, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs((int)startIndex).scoreDocs;
            int iterations = hits.length > pageSize ? pageSize : hits.length;
            for (int i = 0; i < iterations; ++i) {
                result.add(KObjectUtil.toKObject((Document)index.doc(hits[i].doc)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            indexManager.release(index);
        }
        return result;
    }

    private List<KObject> search(Query query, int totalHits, ClusterSegment ... clusterSegments) {
        LuceneIndexManager indexManager = (LuceneIndexManager)this.config.getIndexManager();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)totalHits, (boolean)true);
        IndexSearcher index = indexManager.getIndexSearcher(clusterSegments);
        ArrayList<KObject> result = new ArrayList<KObject>();
        try {
            index.search(query, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            for (int i = 0; i < hits.length; ++i) {
                result.add(KObjectUtil.toKObject((Document)index.doc(hits[i].doc)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            indexManager.release(index);
        }
        return result;
    }
}

