/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.NormalizedTerms;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SearchEmptyQueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.RuleNameResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.PackageNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.ProjectRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@ApplicationScoped
public class FindRulesByProjectQuery
implements NamedQuery {
    public static String FIND_RULES_BY_PROJECT_QUERY = "FindRulesByProjectQuery";
    @Inject
    private RuleNameResponseBuilder responseBuilder;

    @Override
    public String getName() {
        return FIND_RULES_BY_PROJECT_QUERY;
    }

    @Override
    public Set<IndexTerm> getTerms() {
        return new HashSet<IndexTerm>(){
            {
                this.add(new PackageNameIndexTerm());
                this.add(new ProjectRootPathIndexTerm());
            }
        };
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms, boolean useWildcards) {
        PortablePreconditions.checkNotNull((String)"terms", terms);
        NormalizedTerms normalizedTerms = new NormalizedTerms(terms, "packageName", "projectRoot");
        SearchEmptyQueryBuilder queryBuilder = new SearchEmptyQueryBuilder(useWildcards);
        queryBuilder.addTerm(normalizedTerms.get("packageName")).addTerm(normalizedTerms.get("projectRoot")).addRuleNameWildCardTerm();
        return queryBuilder.build();
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }
}

