/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.persistence;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.persistence.SocialClusterMessaging;
import org.kie.uberfire.social.activities.persistence.SocialTimelineCachePersistence;
import org.kie.uberfire.social.activities.security.SocialSecurityConstraintsManager;
import org.kie.uberfire.social.activities.server.SocialUserServicesExtendedBackEndImpl;
import org.kie.uberfire.social.activities.service.SocialEventTypeRepositoryAPI;
import org.kie.uberfire.social.activities.service.SocialTimelinePersistenceAPI;
import org.kie.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.commons.lifecycle.PriorityDisposable;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class SocialTimelineCacheClusterPersistence
extends SocialTimelineCachePersistence
implements SocialTimelinePersistenceAPI {
    private SocialClusterMessaging socialClusterMessaging;

    public SocialTimelineCacheClusterPersistence(Gson gson, Type gsonCollectionType, IOService ioService, SocialEventTypeRepositoryAPI socialEventTypeRepository, SocialUserPersistenceAPI socialUserPersistenceAPI, SocialClusterMessaging socialClusterMessaging, SocialUserServicesExtendedBackEndImpl userServicesBackend, FileSystem fileSystem, SocialSecurityConstraintsManager socialSecurityConstraintsManager) {
        this.gson = gson;
        this.gsonCollectionType = gsonCollectionType;
        this.ioService = ioService;
        this.socialEventTypeRepository = socialEventTypeRepository;
        this.socialUserPersistenceAPI = socialUserPersistenceAPI;
        this.socialClusterMessaging = socialClusterMessaging;
        this.userServicesBackend = userServicesBackend;
        this.fileSystem = fileSystem;
        this.socialSecurityConstraintsManager = socialSecurityConstraintsManager;
        PriorityDisposableRegistry.register((PriorityDisposable)this);
    }

    public void persist(SocialActivitiesEvent event) {
        SocialEventType type = this.socialEventTypeRepository.findType(event.getType());
        this.persistEvent(event, type, true);
    }

    public void persist(SocialUser user, SocialActivitiesEvent event) {
        if (!this.clusterSyncEvent(event)) {
            this.registerNewEvent(user, event);
        } else {
            this.syncCluster(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllEvents() {
        if (!this.typeEventsTimelineCache.keySet().isEmpty()) {
            try {
                SocialEventType sampleType = (SocialEventType)this.typeEventsTimelineCache.keySet().iterator().next();
                Path timeLineDir = this.userServicesBackend.buildPath("social-files", sampleType.name());
                this.ioService.startBatch(timeLineDir.getFileSystem());
                this.socialClusterMessaging.notifySomeInstanceisOnShutdown();
                this.saveAllTypeEvents();
                this.saveAllUserTimelines();
            }
            catch (Exception e) {
                System.out.println();
            }
            finally {
                this.ioService.endBatch();
            }
        }
    }

    private void registerNewEvent(SocialUser user, SocialActivitiesEvent event) {
        ArrayList<SocialActivitiesEvent> userEvents = (ArrayList<SocialActivitiesEvent>)this.userEventsTimelineFreshEvents.get(user.getUserName());
        if (userEvents == null) {
            userEvents = new ArrayList<SocialActivitiesEvent>();
        }
        userEvents.add(event);
        this.userEventsTimelineFreshEvents.put(user.getUserName(), userEvents);
        this.cacheControl(user);
    }

    private void syncCluster(SocialUser user) {
        List myFreshEvents = (List)this.userEventsTimelineFreshEvents.get(user.getUserName());
        SocialTimelineCachePersistence.SocialCacheControl socialCacheControl = (SocialTimelineCachePersistence.SocialCacheControl)this.userEventsCacheControl.get(user.getUserName());
        socialCacheControl.reset();
        List<SocialActivitiesEvent> actualTypeTimeline = this.createOrGetUserTimeline(user.getUserName());
        this.refreshCache(user.getUserName(), actualTypeTimeline);
        this.syncMyStaleItems((List<SocialActivitiesEvent>)myFreshEvents, actualTypeTimeline, user);
    }

    private void syncCluster(SocialEventType eventType) {
        List myFreshEvents = (List)this.typeEventsFreshEvents.get(eventType);
        SocialTimelineCachePersistence.SocialCacheControl socialCacheControl = (SocialTimelineCachePersistence.SocialCacheControl)this.typeEventsCacheControl.get(eventType);
        socialCacheControl.reset();
        List<SocialActivitiesEvent> actualTypeTimeline = this.createOrGetTypeTimeline(eventType);
        this.refreshCache(eventType, actualTypeTimeline);
        this.syncMyStaleItems((List<SocialActivitiesEvent>)myFreshEvents, actualTypeTimeline, eventType);
    }

    void persist(SocialActivitiesEvent event, SocialEventType type, boolean sendClusterMsg) {
        this.persistEvent(event, type, sendClusterMsg);
    }

    private void persistEvent(SocialActivitiesEvent event, SocialEventType eventType, boolean sendClusterMsg) {
        if (!this.clusterSyncEvent(event)) {
            this.registerNewEvent(event, eventType, sendClusterMsg);
        } else {
            this.syncCluster(eventType);
        }
    }

    private void registerNewEvent(SocialActivitiesEvent event, SocialEventType eventType, boolean sendClusterMsg) {
        List typeEvents = (List)this.typeEventsFreshEvents.get(eventType);
        typeEvents.add(event);
        this.typeEventsFreshEvents.put(eventType, typeEvents);
        this.cacheControl(event, eventType);
        if (sendClusterMsg) {
            this.socialClusterMessaging.notify(event);
        }
    }

    private boolean clusterSyncEvent(SocialActivitiesEvent event) {
        return event.isDummyEvent();
    }

    private void syncMyStaleItems(List<SocialActivitiesEvent> myFreshEvents, List<SocialActivitiesEvent> storedTimeline, SocialEventType eventType) {
        List<SocialActivitiesEvent> unsavedEvents = this.findStaleEvents(myFreshEvents, storedTimeline);
        if (!unsavedEvents.isEmpty()) {
            List cacheEvents = (List)this.typeEventsFreshEvents.get(eventType);
            cacheEvents.addAll(unsavedEvents);
            this.typeEventsFreshEvents.put(eventType, cacheEvents);
        }
    }

    private void syncMyStaleItems(List<SocialActivitiesEvent> myFreshEvents, List<SocialActivitiesEvent> storedTimeline, SocialUser user) {
        List<SocialActivitiesEvent> unsavedEvents = this.findStaleEvents(myFreshEvents, storedTimeline);
        if (!unsavedEvents.isEmpty()) {
            List cacheEvents = (List)this.userEventsTimelineFreshEvents.get(user.getUserName());
            cacheEvents.addAll(unsavedEvents);
            this.userEventsTimelineFreshEvents.put(user.getUserName(), cacheEvents);
        }
    }

    private List<SocialActivitiesEvent> findStaleEvents(List<SocialActivitiesEvent> myFreshEvents, List<SocialActivitiesEvent> storedTimeline) {
        ArrayList<SocialActivitiesEvent> unsavedEvents = new ArrayList<SocialActivitiesEvent>();
        for (SocialActivitiesEvent myEvent : myFreshEvents) {
            boolean hasEvent = false;
            for (SocialActivitiesEvent storedEvents : storedTimeline) {
                if (!storedEvents.equals((Object)myEvent)) continue;
                hasEvent = true;
                break;
            }
            if (hasEvent) continue;
            unsavedEvents.add(myEvent);
        }
        return unsavedEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheControl(SocialUser user) {
        SocialTimelineCachePersistence.SocialCacheControl socialCacheControl = (SocialTimelineCachePersistence.SocialCacheControl)this.userEventsCacheControl.get(user.getUserName());
        if (socialCacheControl == null) {
            socialCacheControl = new SocialTimelineCachePersistence.SocialCacheControl(this);
            this.userEventsCacheControl.put(user.getUserName(), socialCacheControl);
        }
        socialCacheControl.registerNewEvent();
        if (socialCacheControl.needToPersist()) {
            Path userDir = this.getUserDirectory(user.getUserName());
            try {
                this.ioService.startBatch(userDir.getFileSystem());
                List<SocialActivitiesEvent> storedEvents = this.storeTimeLineInFile(user);
                this.socialClusterMessaging.notifyTimeLineUpdate(user, storedEvents);
                socialCacheControl.reset();
            }
            finally {
                this.ioService.endBatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheControl(SocialActivitiesEvent event, SocialEventType eventType) {
        SocialEventType type = this.socialEventTypeRepository.findType(event.getType());
        SocialTimelineCachePersistence.SocialCacheControl socialCacheControl = (SocialTimelineCachePersistence.SocialCacheControl)this.typeEventsCacheControl.get(type);
        socialCacheControl.registerNewEvent();
        if (socialCacheControl.needToPersist()) {
            Path timeLineDir = this.userServicesBackend.buildPath("social-files", type.name());
            try {
                this.ioService.startBatch(timeLineDir.getFileSystem());
                this.socialClusterMessaging.notifyTimeLineUpdate(event);
                this.storeTimeLineInFile(eventType);
                socialCacheControl.reset();
            }
            finally {
                this.ioService.endBatch();
            }
        }
    }

    public void someNodeShutdownAndPersistEvents() {
        for (SocialEventType socialEventType : this.typeEventsFreshEvents.keySet()) {
            List freshEvents = (List)this.typeEventsFreshEvents.get(socialEventType);
            this.refreshCache(socialEventType, (List<SocialActivitiesEvent>)freshEvents);
        }
        for (String user : this.userEventsTimelineFreshEvents.keySet()) {
            List userEvents = (List)this.userEventsTimelineFreshEvents.get(user);
            this.refreshCache(user, (List<SocialActivitiesEvent>)userEvents);
        }
    }
}

