/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.uberfire.social.activities.model.PagedSocialQuery;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialPaged;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.repository.SocialPageRepository;
import org.kie.uberfire.social.activities.service.SocialPredicate;
import org.kie.uberfire.social.activities.service.SocialUserTimelinePagedRepositoryAPI;

@Service
@ApplicationScoped
public class SocialUserTimelinePagedRepository
extends SocialPageRepository
implements SocialUserTimelinePagedRepositoryAPI {
    public PagedSocialQuery getUserTimeline(SocialUser socialUser, SocialPaged socialPaged) {
        return this.getUserTimeline(socialUser, socialPaged, new HashMap(), null);
    }

    public PagedSocialQuery getUserTimeline(SocialUser socialUser, SocialPaged socialPaged, SocialPredicate<SocialActivitiesEvent> predicate) {
        return this.getUserTimeline(socialUser, socialPaged, new HashMap(), predicate);
    }

    public PagedSocialQuery getUserTimeline(SocialUser socialUser, SocialPaged socialPaged, Map commandsMap, SocialPredicate<SocialActivitiesEvent> predicate) {
        List<SocialActivitiesEvent> userEvents = new ArrayList<SocialActivitiesEvent>();
        if ((socialPaged = this.setupQueryDirection(socialPaged)).isANewQuery()) {
            socialPaged = this.searchForRecentEvents(socialUser, socialPaged, userEvents, predicate);
        }
        if (!this.foundEnoughtEvents(socialPaged, userEvents)) {
            socialPaged = this.searchForStoredEvents(socialUser, socialPaged, userEvents, predicate);
        }
        userEvents = this.filterTimelineWithAdapters(commandsMap, userEvents);
        this.checkIfICanGoForward(socialPaged, userEvents);
        PagedSocialQuery query = new PagedSocialQuery(userEvents, socialPaged);
        return query;
    }

    private SocialPaged searchForStoredEvents(SocialUser socialUser, SocialPaged socialPaged, List<SocialActivitiesEvent> events, SocialPredicate<SocialActivitiesEvent> predicate) {
        if (socialPaged.firstFileRead()) {
            this.readMostRecentFile(socialUser, socialPaged, events, predicate);
        } else {
            this.readCurrentFile(socialUser, socialPaged, events, predicate);
        }
        if (!this.foundEnoughtEvents(socialPaged, events) && this.shouldIReadMoreFiles(socialPaged)) {
            this.readMoreFiles(socialPaged, socialUser, events, predicate);
        }
        return socialPaged;
    }

    private boolean shouldIReadMoreFiles(SocialPaged socialPaged) {
        return socialPaged.lastFileReaded() != null && !socialPaged.lastFileReaded().isEmpty() && this.thereIsMoreFilesToRead(socialPaged.lastFileReaded());
    }

    private void readMoreFiles(SocialPaged socialPaged, SocialUser socialUser, List<SocialActivitiesEvent> events, SocialPredicate<SocialActivitiesEvent> predicate) {
        String nextFileToRead = socialPaged.getNextFileToRead();
        if (this.thereIsMoreFilesToRead(nextFileToRead)) {
            this.addEventsToTimeline(socialUser, socialPaged, events, nextFileToRead, predicate);
            if (!this.foundEnoughtEvents(socialPaged, events)) {
                this.readMoreFiles(socialPaged, socialUser, events, predicate);
            }
        }
    }

    private void readCurrentFile(SocialUser socialUser, SocialPaged socialPaged, List<SocialActivitiesEvent> events, SocialPredicate<SocialActivitiesEvent> predicate) {
        String lastFileReaded = socialPaged.lastFileReaded();
        this.addEventsToTimeline(socialUser, socialPaged, events, lastFileReaded, predicate);
    }

    private void addEventsToTimeline(SocialUser socialUser, SocialPaged socialPaged, List<SocialActivitiesEvent> events, String lastFileReaded, SocialPredicate<SocialActivitiesEvent> predicate) {
        List timeline = this.getSocialTimelinePersistenceAPI().getTimeline(socialUser, lastFileReaded);
        List<SocialActivitiesEvent> filteredList = this.filterList(predicate, timeline);
        this.setNumberOfEventsOnFile(socialPaged, socialUser, lastFileReaded);
        this.addEvents(socialPaged, events, filteredList);
    }

    private void setNumberOfEventsOnFile(SocialPaged socialPaged, SocialUser socialUser, String lastFileReaded) {
        socialPaged.setNumberOfEventsOnFile(this.getSocialTimelinePersistenceAPI().getNumberOfEventsOnFile(socialUser, lastFileReaded));
    }

    private void readMostRecentFile(SocialUser socialUser, SocialPaged socialPaged, List<SocialActivitiesEvent> events, SocialPredicate<SocialActivitiesEvent> predicate) {
        Integer userMostRecentFileIndex = this.getSocialTimelinePersistenceAPI().getUserMostRecentFileIndex(socialUser);
        if (this.thereIsNothingToRead(userMostRecentFileIndex)) {
            return;
        }
        List timeline = this.getSocialTimelinePersistenceAPI().getTimeline(socialUser, userMostRecentFileIndex.toString());
        List<SocialActivitiesEvent> filteredList = this.filterList(predicate, timeline);
        socialPaged.setLastFileReaded(userMostRecentFileIndex.toString());
        this.readEvents(socialPaged, events, filteredList);
    }

    private boolean thereIsNothingToRead(Integer userMostRecentFileIndex) {
        return userMostRecentFileIndex < 0;
    }

    private SocialPaged searchForRecentEvents(SocialUser socialUser, SocialPaged socialPaged, List<SocialActivitiesEvent> events, SocialPredicate<SocialActivitiesEvent> predicate) {
        List freshEvents = this.getSocialTimelinePersistenceAPI().getRecentEvents(socialUser);
        List<SocialActivitiesEvent> filteredList = this.filterList(predicate, freshEvents);
        Collections.reverse(filteredList);
        this.searchEvents(socialPaged, events, filteredList);
        return socialPaged;
    }
}

