/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.servlet;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.service.SocialTimeLineRepositoryAPI;
import org.kie.uberfire.social.activities.service.SocialUserRepositoryAPI;
import org.kie.uberfire.social.activities.servlet.AtomSocialTimelineConverter;
import org.kie.uberfire.social.activities.servlet.SocialRouter;

public class SocialUserTimeLineServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Inject
    SocialTimeLineRepositoryAPI timeLineRepositoryAPI;
    @Inject
    SocialUserRepositoryAPI socialUserRepositoryAPI;
    @Inject
    SocialRouter socialRouter;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String userName = this.socialRouter.extractPath(request.getPathInfo());
            SocialUser socialUser = this.socialUserRepositoryAPI.findSocialUser(userName);
            List eventTimeline = this.timeLineRepositoryAPI.getLastUserTimeline(socialUser, request.getParameterMap());
            response.setContentType("application/atom+xml");
            String url = "/social-user" + request.getPathInfo();
            response.getWriter().println(this.createFeed(eventTimeline, url));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String createFeed(List<SocialActivitiesEvent> eventTimeline, String url) {
        return AtomSocialTimelineConverter.generate(eventTimeline, url);
    }
}

