/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.commongrams;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsQueryFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class CommonGramsQueryFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet commonWords;
    private boolean ignoreCase;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.assureMatchVersion();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String commonWordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        this.commonWords = commonWordFiles != null ? ("snowball".equalsIgnoreCase((String)this.args.get("format")) ? this.getSnowballWordSet(loader, commonWordFiles, this.ignoreCase) : this.getWordSet(loader, commonWordFiles, this.ignoreCase)) : StopAnalyzer.ENGLISH_STOP_WORDS_SET;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getCommonWords() {
        return this.commonWords;
    }

    public CommonGramsQueryFilter create(TokenStream input) {
        CommonGramsFilter commonGrams = new CommonGramsFilter(this.luceneMatchVersion, input, this.commonWords);
        CommonGramsQueryFilter commonGramsQuery = new CommonGramsQueryFilter(commonGrams);
        return commonGramsQuery;
    }
}

