/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.interceptor.CustomInterceptorMetadata;
import org.jboss.weld.bean.interceptor.SerializableContextualInterceptorReference;
import org.jboss.weld.bean.interceptor.WeldInterceptorClassMetadata;
import org.jboss.weld.context.SerializableContextualImpl;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.interceptor.InterceptorBindingType;
import org.jboss.weld.interceptor.builder.InterceptionModelBuilder;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionUtils;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

public class InterceptionModelInitializer<T> {
    private static final InterceptorMetadata<?>[] EMPTY_INTERCEPTOR_METADATA_ARRAY = new InterceptorMetadata[0];
    private final BeanManagerImpl beanManager;
    private final WeldClass<T> annotatedType;
    private final Set<Class<? extends Annotation>> stereotypes;
    private final Class<T> type;
    private final ContextualStore contextualStore;
    private boolean hasSerializationOrInvocationInterceptorMethods;
    private Map<Interceptor<?>, InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>>> interceptorMetadatas = new HashMap();
    private List<WeldMethod<?, ?>> businessMethods;
    private InterceptionModelBuilder<ClassMetadata<?>, ?> builder;

    private static <T> InterceptorMetadata<T>[] emptyInterceptorMetadataArray() {
        return (InterceptorMetadata[])Reflections.cast(EMPTY_INTERCEPTOR_METADATA_ARRAY);
    }

    public InterceptionModelInitializer(BeanManagerImpl beanManager, WeldClass<T> annotatedType, Class<T> type) {
        this(beanManager, annotatedType, null, type);
    }

    public InterceptionModelInitializer(BeanManagerImpl beanManager, WeldClass<T> annotatedType, Bean<?> bean, Class<T> type) {
        this.beanManager = beanManager;
        this.annotatedType = annotatedType;
        this.stereotypes = bean != null ? bean.getStereotypes() : Collections.emptySet();
        this.type = type;
        this.contextualStore = (ContextualStore)beanManager.getServices().get(ContextualStore.class);
    }

    public void init() {
        this.initTargetClassInterceptors();
        this.businessMethods = Beans.getInterceptableMethods(this.annotatedType);
        this.builder = InterceptionModelBuilder.newBuilderFor(this.getClassMetadata());
        this.initEjbInterceptors();
        this.initCdiInterceptors();
        InterceptionModel<ClassMetadata<?>, ?> interceptionModel = this.builder.build();
        if (interceptionModel.getAllInterceptors().size() > 0 || this.hasSerializationOrInvocationInterceptorMethods) {
            if (this.annotatedType.isFinal()) {
                throw new DefinitionException(BeanMessage.FINAL_BEAN_CLASS_WITH_INTERCEPTORS_NOT_ALLOWED, this.type);
            }
            this.beanManager.getInterceptorModelRegistry().put(this.type, interceptionModel);
        }
    }

    private ClassMetadata<T> getClassMetadata() {
        return this.beanManager.getInterceptorMetadataReader().getClassMetadata(this.type);
    }

    private void initCdiInterceptors() {
        Set<InterceptorBindingType> classBindings = this.getClassInterceptorBindings();
        this.initCdiLifecycleInterceptors(classBindings);
        this.initCdiBusinessMethodInterceptors(classBindings);
    }

    private Set<InterceptorBindingType> getClassInterceptorBindings() {
        HashSet<InterceptorBindingType> classBindingAnnotations = new HashSet<InterceptorBindingType>();
        classBindingAnnotations.addAll(this.beanManager.extractAndFlattenInterceptorBindings(this.annotatedType.getAnnotations()));
        for (Class<? extends Annotation> annotation : this.stereotypes) {
            classBindingAnnotations.addAll(this.beanManager.extractAndFlattenInterceptorBindings(this.beanManager.getStereotypeDefinition(annotation)));
        }
        return classBindingAnnotations;
    }

    private void initCdiLifecycleInterceptors(Set<InterceptorBindingType> classBindings) {
        if (classBindings.size() == 0) {
            return;
        }
        if (Beans.findInterceptorBindingConflicts(classBindings)) {
            throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.type);
        }
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.POST_CONSTRUCT, classBindings);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.PRE_DESTROY, classBindings);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.PRE_PASSIVATE, classBindings);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.POST_ACTIVATE, classBindings);
    }

    private void initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType interceptionType, Set<InterceptorBindingType> interceptorBindingTypes) {
        List<Interceptor<?>> resolvedInterceptors = this.beanManager.resolveInterceptors(interceptionType, interceptorBindingTypes);
        this.builder.intercept(interceptionType).with(this.toSerializableContextualArray(resolvedInterceptors));
    }

    private void initCdiBusinessMethodInterceptors(Set<InterceptorBindingType> classBindings) {
        for (WeldMethod<?, ?> method : this.businessMethods) {
            this.initCdiBusinessMethodInterceptor(method, this.getMethodInterceptorBindings(classBindings, method));
        }
    }

    private Set<InterceptorBindingType> getMethodInterceptorBindings(Set<InterceptorBindingType> classBindingAnnotations, WeldMethod<?, ?> method) {
        HashSet<InterceptorBindingType> methodBindingAnnotations = new HashSet<InterceptorBindingType>();
        methodBindingAnnotations.addAll(classBindingAnnotations);
        methodBindingAnnotations.addAll(this.beanManager.extractAndFlattenInterceptorBindings(method.getAnnotations()));
        return methodBindingAnnotations;
    }

    private void initCdiBusinessMethodInterceptor(WeldMethod<?, ?> method, Set<InterceptorBindingType> methodInterceptorBindings) {
        if (methodInterceptorBindings.size() == 0) {
            return;
        }
        if (Beans.findInterceptorBindingConflicts(methodInterceptorBindings)) {
            throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.type + "." + method.getName() + "()");
        }
        this.initInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE, method, methodInterceptorBindings);
        this.initInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT, method, methodInterceptorBindings);
    }

    private void initInterceptor(javax.enterprise.inject.spi.InterceptionType interceptionType, WeldMethod<?, ?> method, Set<InterceptorBindingType> interceptorBindingTypes) {
        List<Interceptor<?>> methodBoundInterceptors = this.beanManager.resolveInterceptors(interceptionType, interceptorBindingTypes);
        if (methodBoundInterceptors != null && methodBoundInterceptors.size() > 0) {
            if (method.isFinal()) {
                throw new DefinitionException(BeanMessage.FINAL_INTERCEPTED_BEAN_METHOD_NOT_ALLOWED, method, methodBoundInterceptors.get(0).getBeanClass().getName());
            }
            Method javaMethod = ((AnnotatedMethod)Reflections.cast(method)).getJavaMember();
            this.builder.intercept(interceptionType, javaMethod).with(this.toSerializableContextualArray(methodBoundInterceptors));
        }
    }

    private void initEjbInterceptors() {
        this.initClassDeclaredEjbInterceptors();
        for (WeldMethod<?, ?> method : this.businessMethods) {
            this.initMethodDeclaredEjbInterceptors(method);
        }
    }

    private void initClassDeclaredEjbInterceptors() {
        Class<?>[] classDeclaredInterceptors = null;
        if (this.annotatedType.isAnnotationPresent(InterceptionUtils.getInterceptorsAnnotationClass())) {
            Annotation interceptorsAnnotation = this.annotatedType.getAnnotation(InterceptionUtils.getInterceptorsAnnotationClass());
            classDeclaredInterceptors = SecureReflections.extractValues(interceptorsAnnotation);
        }
        if (classDeclaredInterceptors != null) {
            for (Class<?> clazz : classDeclaredInterceptors) {
                this.builder.interceptAll().with(this.beanManager.getInterceptorMetadataReader().getInterceptorMetadata(clazz));
            }
        }
    }

    private void initMethodDeclaredEjbInterceptors(WeldMethod<?, ?> method) {
        Class<?>[] methodDeclaredInterceptors;
        Method javaMethod = ((AnnotatedMethod)Reflections.cast(method)).getJavaMember();
        boolean excludeClassInterceptors = method.isAnnotationPresent(InterceptionUtils.getExcludeClassInterceptorsAnnotationClass());
        if (excludeClassInterceptors) {
            this.builder.ignoreGlobalInterceptors(javaMethod);
        }
        if ((methodDeclaredInterceptors = this.getMethodDeclaredInterceptors(method)) != null && methodDeclaredInterceptors.length > 0) {
            if (method.isFinal()) {
                throw new DefinitionException(BeanMessage.FINAL_INTERCEPTED_BEAN_METHOD_NOT_ALLOWED, method, methodDeclaredInterceptors[0].getName());
            }
            javax.enterprise.inject.spi.InterceptionType interceptionType = this.isTimeoutAnnotationPresentOn(method) ? javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT : javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE;
            InterceptorMetadata[] interceptors = this.getMethodDeclaredInterceptorMetadatas(methodDeclaredInterceptors);
            this.builder.intercept(interceptionType, javaMethod).with(interceptors);
        }
    }

    private InterceptorMetadata[] getMethodDeclaredInterceptorMetadatas(Class<?>[] methodDeclaredInterceptors) {
        ArrayList list = new ArrayList();
        for (Class<?> clazz : methodDeclaredInterceptors) {
            list.add(this.beanManager.getInterceptorMetadataReader().getInterceptorMetadata(clazz));
        }
        return list.toArray(new InterceptorMetadata[list.size()]);
    }

    private boolean isTimeoutAnnotationPresentOn(WeldMethod<?, ?> method) {
        return method.isAnnotationPresent(((EJBApiAbstraction)this.beanManager.getServices().get(EJBApiAbstraction.class)).TIMEOUT_ANNOTATION_CLASS);
    }

    private Class<?>[] getMethodDeclaredInterceptors(WeldMethod<?, ?> method) {
        Class<?>[] methodDeclaredInterceptors = null;
        if (method.isAnnotationPresent(InterceptionUtils.getInterceptorsAnnotationClass())) {
            methodDeclaredInterceptors = SecureReflections.extractValues(method.getAnnotation(InterceptionUtils.getInterceptorsAnnotationClass()));
        }
        return methodDeclaredInterceptors;
    }

    private InterceptorMetadata<SerializableContextual<?, ?>>[] toSerializableContextualArray(List<Interceptor<?>> interceptors) {
        ArrayList serializableContextuals = new ArrayList();
        for (Interceptor<?> interceptor : interceptors) {
            serializableContextuals.add(this.getCachedInterceptorMetadata(interceptor));
        }
        return serializableContextuals.toArray(InterceptionModelInitializer.emptyInterceptorMetadataArray());
    }

    private InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>> getCachedInterceptorMetadata(Interceptor<?> interceptor) {
        InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>> interceptorMetadata = this.interceptorMetadatas.get(interceptor);
        if (interceptorMetadata == null) {
            interceptorMetadata = this.getInterceptorMetadata(interceptor);
            this.interceptorMetadatas.put(interceptor, interceptorMetadata);
        }
        return interceptorMetadata;
    }

    private InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>> getInterceptorMetadata(Interceptor<?> interceptor) {
        SerializableContextualImpl contextual = new SerializableContextualImpl(interceptor, this.contextualStore);
        if (interceptor instanceof InterceptorImpl) {
            InterceptorImpl interceptorImpl = (InterceptorImpl)interceptor;
            WeldInterceptorClassMetadata classMetadata = WeldInterceptorClassMetadata.of(interceptorImpl.getWeldAnnotated());
            SerializableContextualInterceptorReference interceptorReference = new SerializableContextualInterceptorReference(contextual, classMetadata);
            return this.beanManager.getInterceptorMetadataReader().getInterceptorMetadata(interceptorReference);
        }
        ClassMetadata classMetadata = this.beanManager.getInterceptorMetadataReader().getClassMetadata(interceptor.getBeanClass());
        return new CustomInterceptorMetadata(new SerializableContextualInterceptorReference(contextual, null), classMetadata);
    }

    private void initTargetClassInterceptors() {
        InterceptorMetadata<T> interceptorClassMetadata;
        this.hasSerializationOrInvocationInterceptorMethods = !Beans.isInterceptor(this.annotatedType) ? (interceptorClassMetadata = this.beanManager.getInterceptorMetadataReader().getTargetClassInterceptorMetadata(WeldInterceptorClassMetadata.of(this.annotatedType))).isEligible(InterceptionType.AROUND_INVOKE) || interceptorClassMetadata.isEligible(InterceptionType.AROUND_TIMEOUT) || interceptorClassMetadata.isEligible(InterceptionType.PRE_PASSIVATE) || interceptorClassMetadata.isEligible(InterceptionType.POST_ACTIVATE) : false;
    }
}

