/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40.values;

import java.io.IOException;
import org.apache.lucene.codecs.lucene40.values.Bytes;
import org.apache.lucene.codecs.lucene40.values.DirectSource;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedInts;

class FixedDerefBytesImpl {
    static final String CODEC_NAME_IDX = "FixedDerefBytesIdx";
    static final String CODEC_NAME_DAT = "FixedDerefBytesDat";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    FixedDerefBytesImpl() {
    }

    static final class DirectFixedDerefSource
    extends DirectSource {
        private final PackedInts.Reader index;
        private final int size;

        DirectFixedDerefSource(IndexInput data, IndexInput index, int size, DocValues.Type type) throws IOException {
            super(data, type);
            this.size = size;
            this.index = PackedInts.getDirectReader(index);
        }

        @Override
        protected int position(int docID) throws IOException {
            this.data.seek(this.baseOffset + this.index.get(docID) * (long)this.size);
            return this.size;
        }
    }

    static final class FixedDerefSource
    extends Bytes.BytesSourceBase {
        private final int size;
        private final PackedInts.Reader addresses;

        protected FixedDerefSource(IndexInput datIn, IndexInput idxIn, int size, long numValues) throws IOException {
            super(datIn, idxIn, new PagedBytes(15), (long)size * numValues, DocValues.Type.BYTES_FIXED_DEREF);
            this.size = size;
            this.addresses = PackedInts.getReader(idxIn);
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef bytesRef) {
            return this.data.fillSlice(bytesRef, this.addresses.get(docID) * (long)this.size, this.size);
        }
    }

    public static class FixedDerefReader
    extends Bytes.BytesReaderBase {
        private final int size;
        private final int numValuesStored;

        FixedDerefReader(Directory dir, String id, int maxDoc, IOContext context) throws IOException {
            super(dir, id, FixedDerefBytesImpl.CODEC_NAME_IDX, FixedDerefBytesImpl.CODEC_NAME_DAT, 0, true, context, DocValues.Type.BYTES_FIXED_DEREF);
            this.size = this.datIn.readInt();
            this.numValuesStored = this.idxIn.readInt();
        }

        @Override
        public DocValues.Source load() throws IOException {
            return new FixedDerefSource(this.cloneData(), this.cloneIndex(), this.size, this.numValuesStored);
        }

        @Override
        public DocValues.Source getDirectSource() throws IOException {
            return new DirectFixedDerefSource(this.cloneData(), this.cloneIndex(), this.size, this.getType());
        }

        @Override
        public int getValueSize() {
            return this.size;
        }
    }

    public static class Writer
    extends Bytes.DerefBytesWriterBase {
        public Writer(Directory dir, String id, Counter bytesUsed, IOContext context) {
            super(dir, id, FixedDerefBytesImpl.CODEC_NAME_IDX, FixedDerefBytesImpl.CODEC_NAME_DAT, 0, bytesUsed, context, DocValues.Type.BYTES_FIXED_DEREF);
        }

        @Override
        protected void finishInternal(int docCount) throws IOException {
            int numValues = this.hash.size();
            IndexOutput datOut = this.getOrCreateDataOut();
            datOut.writeInt(this.size);
            if (this.size != -1) {
                BytesRef bytesRef = new BytesRef(this.size);
                for (int i = 0; i < numValues; ++i) {
                    this.hash.get(i, bytesRef);
                    datOut.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                }
            }
            IndexOutput idxOut = this.getOrCreateIndexOut();
            idxOut.writeInt(numValues);
            this.writeIndex(idxOut, docCount, numValues, this.docToEntry);
        }
    }
}

