/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.helix.monitoring.mbeans.InstanceMonitorMBean;

public class InstanceMonitor
implements InstanceMonitorMBean {
    private final String _clusterName;
    private final String _participantName;
    private List<String> _tags;
    private List<String> _disabledPartitions;
    private boolean _isUp;
    private boolean _isEnabled;

    public InstanceMonitor(String clusterName, String participantName) {
        this._clusterName = clusterName;
        this._participantName = participantName;
        this._tags = ImmutableList.of((Object)"DEFAULT");
        this._disabledPartitions = Collections.emptyList();
        this._isUp = false;
        this._isEnabled = false;
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s.%s", "ParticipantStatus", this._clusterName, this.serializedTags(), this._participantName);
    }

    @Override
    public long getOnline() {
        return this._isUp ? 1L : 0L;
    }

    @Override
    public long getEnabled() {
        return this._isEnabled ? 1L : 0L;
    }

    public List<String> getTags() {
        return this._tags;
    }

    public String getInstanceName() {
        return this._participantName;
    }

    public String getBeanName() {
        return this._clusterName + " " + this.serializedTags() + " " + this._participantName;
    }

    private String serializedTags() {
        return Joiner.on((char)'|').skipNulls().join(this._tags).toString();
    }

    public synchronized void updateInstance(Set<String> tags, Set<String> disabledPartitions, boolean isLive, boolean isEnabled) {
        if (tags == null || tags.isEmpty()) {
            this._tags = ImmutableList.of((Object)"DEFAULT");
        } else {
            this._tags = Lists.newArrayList(tags);
            Collections.sort(this._tags);
        }
        if (disabledPartitions == null) {
            this._disabledPartitions = Collections.emptyList();
        } else {
            this._disabledPartitions = Lists.newArrayList(disabledPartitions);
            Collections.sort(this._disabledPartitions);
        }
        this._isUp = isLive;
        this._isEnabled = isEnabled;
    }
}

