/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.log4j.Logger;

public final class ZNRecordUtil {
    private static final Logger logger = Logger.getLogger((String)ZNRecordUtil.class.getName());

    private ZNRecordUtil() {
    }

    public static ZNRecord find(String id, List<ZNRecord> list) {
        for (ZNRecord record : list) {
            if (record.getId() == null || !record.getId().equals(id)) continue;
            return record;
        }
        return null;
    }

    public static Map<String, ZNRecord> convertListToMap(List<ZNRecord> recordList) {
        HashMap<String, ZNRecord> recordMap = new HashMap<String, ZNRecord>();
        for (ZNRecord record : recordList) {
            if (record.getId() == null) continue;
            recordMap.put(record.getId(), record);
        }
        return recordMap;
    }

    public static <T> List<T> convertListToTypedList(List<ZNRecord> recordList, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        for (ZNRecord record : recordList) {
            if (record.getId() == null) {
                logger.error((Object)("Invalid record: Id missing in " + record));
                continue;
            }
            try {
                Constructor<T> constructor = clazz.getConstructor(ZNRecord.class);
                T instance = constructor.newInstance(record);
                list.add(instance);
            }
            catch (Exception e) {
                logger.error((Object)("Error creating an Object of type:" + clazz.getCanonicalName()), (Throwable)e);
            }
        }
        return list;
    }

    public static <T> Map<String, T> convertListToTypedMap(List<ZNRecord> recordList, Class<T> clazz) {
        HashMap<String, T> map = new HashMap<String, T>();
        for (ZNRecord record : recordList) {
            if (record.getId() == null) {
                logger.error((Object)("Invalid record: Id missing in " + record));
                continue;
            }
            try {
                Constructor<T> constructor = clazz.getConstructor(ZNRecord.class);
                T instance = constructor.newInstance(record);
                map.put(record.getId(), instance);
            }
            catch (Exception e) {
                logger.error((Object)("Error creating an Object of type:" + clazz.getCanonicalName()), (Throwable)e);
            }
        }
        return map;
    }

    public static <T> List<T> convertMapToList(Map<String, T> map) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : map.values()) {
            list.add(t);
        }
        return list;
    }
}

