/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.Iterator;
import java.util.List;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AST;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Modifier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.VisibilityScoped;
import org.jboss.forge.roaster.model.ast.AnnotationAccessor;
import org.jboss.forge.roaster.model.ast.ModifierAccessor;
import org.jboss.forge.roaster.model.impl.JavaDocImpl;
import org.jboss.forge.roaster.model.impl.TypeImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.VisibilityScopedSource;
import org.jboss.forge.roaster.model.util.Strings;
import org.jboss.forge.roaster.model.util.Types;

public class FieldImpl<O extends JavaSource<O>>
implements FieldSource<O> {
    private final AnnotationAccessor<O, FieldSource<O>> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    private O parent;
    private AST ast;
    private final FieldDeclaration field;
    private final VariableDeclarationFragment fragment;

    private void init(O parent) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
    }

    public FieldImpl(O parent) {
        this.init(parent);
        this.fragment = this.ast.newVariableDeclarationFragment();
        this.field = this.ast.newFieldDeclaration(this.fragment);
    }

    public FieldImpl(O parent, Object internal) {
        this(parent, internal, false);
    }

    public FieldImpl(O parent, Object internal, boolean copy) {
        this.init(parent);
        if (copy) {
            VariableDeclarationFragment newFieldFragment = (VariableDeclarationFragment)internal;
            FieldDeclaration newFieldDeclaration = (FieldDeclaration)newFieldFragment.getParent();
            this.field = (FieldDeclaration)ASTNode.copySubtree(this.ast, newFieldDeclaration);
            Iterator fragmentsIterator = this.field.fragments().iterator();
            VariableDeclarationFragment temp = null;
            while (fragmentsIterator.hasNext()) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragmentsIterator.next();
                if (newFieldFragment.getName().getFullyQualifiedName().equals(variableDeclarationFragment.getName().getFullyQualifiedName())) {
                    temp = variableDeclarationFragment;
                    continue;
                }
                fragmentsIterator.remove();
            }
            this.fragment = temp;
        } else {
            this.fragment = (VariableDeclarationFragment)internal;
            this.field = (FieldDeclaration)this.fragment.getParent();
        }
    }

    public O getOrigin() {
        return (O)((JavaSource)this.parent.getOrigin());
    }

    public Object getInternal() {
        return this.fragment;
    }

    public AnnotationSource<O> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, FieldSource<O>>)this, this.field);
    }

    public AnnotationSource<O> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.annotations.addAnnotation((AnnotationTargetSource<O, FieldSource<O>>)this, (ASTNode)this.field, clazz.getSimpleName());
    }

    public AnnotationSource<O> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, FieldSource<O>>)this, (ASTNode)this.field, className);
    }

    public List<AnnotationSource<O>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<O, FieldSource<O>>)this, this.field);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, this.field, type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, this.field, type);
    }

    public AnnotationSource<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, FieldSource<O>>)this, (ASTNode)this.field, (Class<java.lang.annotation.Annotation>)type);
    }

    public AnnotationSource<O> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, FieldSource<O>>)this, (ASTNode)this.field, type);
    }

    public FieldSource<O> removeAnnotation(Annotation<O> annotation) {
        return this.annotations.removeAnnotation(this, this.field, annotation);
    }

    public String toString() {
        return this.field.toString();
    }

    public boolean isFinal() {
        return this.modifiers.hasModifier(this.field, Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    public FieldSource<O> setFinal(boolean finl) {
        if (finl) {
            this.modifiers.addModifier(this.field, Modifier.ModifierKeyword.FINAL_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.field, Modifier.ModifierKeyword.FINAL_KEYWORD);
        }
        return this;
    }

    public boolean isStatic() {
        return this.getOrigin().isInterface() || this.modifiers.hasModifier(this.field, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    public FieldSource<O> setStatic(boolean statc) {
        if (statc) {
            this.modifiers.addModifier(this.field, Modifier.ModifierKeyword.STATIC_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.field, Modifier.ModifierKeyword.STATIC_KEYWORD);
        }
        return this;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public FieldSource<O> setPackagePrivate() {
        this.modifiers.clearVisibility(this.field);
        return this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier(this.field, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public FieldSource<O> setPublic() {
        this.modifiers.clearVisibility(this.field);
        this.modifiers.addModifier(this.field, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier(this.field, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public FieldSource<O> setPrivate() {
        this.modifiers.clearVisibility(this.field);
        this.modifiers.addModifier(this.field, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier(this.field, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public FieldSource<O> setProtected() {
        this.modifiers.clearVisibility(this.field);
        this.modifiers.addModifier(this.field, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return this;
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public FieldSource<O> setVisibility(Visibility scope) {
        return (FieldSource)Visibility.set((VisibilityScopedSource)this, (Visibility)scope);
    }

    public String getName() {
        String result = null;
        for (Object f : this.field.fragments()) {
            if (!(f instanceof VariableDeclarationFragment)) continue;
            VariableDeclarationFragment frag = (VariableDeclarationFragment)f;
            result = frag.getName().getFullyQualifiedName();
            break;
        }
        return result;
    }

    public FieldSource<O> setName(String name) {
        this.fragment.setName(this.ast.newSimpleName(name));
        return this;
    }

    public Type<O> getType() {
        return new TypeImpl<O>(this.parent, this.field.getStructuralProperty(FieldDeclaration.TYPE_PROPERTY));
    }

    public FieldSource<O> setType(Class<?> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.setType(clazz.getSimpleName());
    }

    public FieldSource<O> setType(JavaType<?> source) {
        return this.setType(source.getQualifiedName());
    }

    public FieldSource<O> setType(String typeName) {
        String simpleName = Types.toSimpleName((String)typeName);
        O origin = this.getOrigin();
        if (!Strings.areEqual((String)typeName, (String)simpleName) && origin.requiresImport(typeName)) {
            origin.addImport(typeName);
        }
        String stub = "public class Stub { " + simpleName + " field; }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List fields = temp.getFields();
        org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type fieldType = ((FieldDeclaration)((VariableDeclarationFragment)((FieldSource)fields.get(0)).getInternal()).getParent()).getType();
        fieldType = (org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type)ASTNode.copySubtree(this.field.getAST(), fieldType);
        this.field.setType(fieldType);
        return this;
    }

    public String getLiteralInitializer() {
        Expression expression = this.fragment.getInitializer();
        return expression != null ? expression.toString() : null;
    }

    public String getStringInitializer() {
        Expression expression = this.fragment.getInitializer();
        return expression != null ? Strings.unquote((String)expression.toString()) : null;
    }

    public FieldSource<O> setLiteralInitializer(String value) {
        String stub = "public class Stub { private Object stub = " + value + " }";
        JavaClass temp = (JavaClass)Roaster.parse(JavaClass.class, (String)stub);
        VariableDeclarationFragment tempFrag = (VariableDeclarationFragment)((Field)temp.getFields().get(0)).getInternal();
        this.fragment.setInitializer((Expression)ASTNode.copySubtree(this.ast, tempFrag.getInitializer()));
        return this;
    }

    public FieldSource<O> setStringInitializer(String value) {
        return this.setLiteralInitializer(Strings.enquote((String)value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldImpl other = (FieldImpl)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        return !(this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment));
    }

    public boolean isTransient() {
        return this.modifiers.hasModifier(this.field, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
    }

    public FieldSource<O> setTransient(boolean value) {
        if (value) {
            this.modifiers.addModifier(this.field, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.field, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
        }
        return this;
    }

    public boolean isVolatile() {
        return this.modifiers.hasModifier(this.field, Modifier.ModifierKeyword.VOLATILE_KEYWORD);
    }

    public FieldSource<O> setVolatile(boolean value) {
        if (value) {
            this.modifiers.addModifier(this.field, Modifier.ModifierKeyword.VOLATILE_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.field, Modifier.ModifierKeyword.VOLATILE_KEYWORD);
        }
        return this;
    }

    public boolean hasJavaDoc() {
        return this.field.getJavadoc() != null;
    }

    public FieldSource<O> removeJavaDoc() {
        this.field.setJavadoc(null);
        return this;
    }

    public JavaDocSource<FieldSource<O>> getJavaDoc() {
        Javadoc javadoc = this.field.getJavadoc();
        if (javadoc == null) {
            javadoc = this.field.getAST().newJavadoc();
            this.field.setJavadoc(javadoc);
        }
        return new JavaDocImpl<FieldSource<O>>(this, javadoc);
    }
}

