/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.jgroups.View;
import org.jgroups.conf.PropertyConverter;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

public final class PropertyConverters {
    private PropertyConverters() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static class Default
    implements PropertyConverter {
        static final String prefix;

        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope) throws Exception {
            if (propertyValue == null) {
                throw new NullPointerException("Property value cannot be null");
            }
            if (Boolean.TYPE.equals(propertyFieldType)) {
                return Boolean.parseBoolean(propertyValue);
            }
            if (Integer.TYPE.equals(propertyFieldType)) {
                return Util.readBytesInteger(propertyValue);
            }
            if (Long.TYPE.equals(propertyFieldType)) {
                return Util.readBytesLong(propertyValue);
            }
            if (Byte.TYPE.equals(propertyFieldType)) {
                return Byte.parseByte(propertyValue);
            }
            if (Double.TYPE.equals(propertyFieldType)) {
                return Util.readBytesDouble(propertyValue);
            }
            if (Short.TYPE.equals(propertyFieldType)) {
                return Short.parseShort(propertyValue);
            }
            if (Float.TYPE.equals(propertyFieldType)) {
                return Float.valueOf(Float.parseFloat(propertyValue));
            }
            if (InetAddress.class.equals(propertyFieldType)) {
                Inet6Address ret;
                Inet6Address addr;
                int scope;
                InetAddress retval = null;
                Util.AddressScope addr_scope = null;
                try {
                    addr_scope = Util.AddressScope.valueOf(propertyValue.toUpperCase());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                retval = addr_scope != null ? Util.getAddress(addr_scope) : (propertyValue.startsWith("match") ? Util.getAddressByPatternMatch(propertyValue) : InetAddress.getByName(propertyValue));
                if (retval instanceof Inet4Address && retval.isMulticastAddress() && Util.getIpStackType() == StackType.IPv6) {
                    String tmp = prefix + propertyValue;
                    retval = InetAddress.getByName(tmp);
                    return retval;
                }
                if (check_scope && retval instanceof Inet6Address && retval.isLinkLocalAddress() && (scope = (addr = (Inet6Address)retval).getScopeId()) == 0 && (ret = Default.getScopedInetAddress(addr)) != null) {
                    retval = ret;
                }
                return retval;
            }
            return propertyValue;
        }

        protected static Inet6Address getScopedInetAddress(Inet6Address addr) {
            if (addr == null) {
                return null;
            }
            ArrayList<InetAddress> retval = new ArrayList<InetAddress>();
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> addrs = intf.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress address = addrs.nextElement();
                        if (!address.isLinkLocalAddress() || !(address instanceof Inet6Address) || !address.equals(addr) || ((Inet6Address)address).getScopeId() == 0) continue;
                        retval.add(address);
                    }
                }
                if (retval.size() == 1) {
                    return (Inet6Address)retval.get(0);
                }
                return null;
            }
            catch (SocketException e) {
                return null;
            }
        }

        @Override
        public String toString(Object value) {
            if (value instanceof InetAddress) {
                return ((InetAddress)value).getHostAddress();
            }
            return value != null ? value.toString() : null;
        }

        static {
            String tmp = "FF0e::";
            try {
                tmp = System.getProperty("jgroups.ipmcast.prefix");
            }
            catch (Throwable t) {
                tmp = "FF0e::";
            }
            prefix = tmp != null ? tmp : "FF0e::";
        }
    }

    public static class StringProperties
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope) throws Exception {
            return Util.parseCommaDelimitedProps(propertyValue);
        }

        @Override
        public String toString(Object value) {
            if (value == null) {
                return null;
            }
            Map v = (Map)value;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry entry : v.entrySet()) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            return sb.toString();
        }
    }

    public static class LongArray
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope) throws Exception {
            long[] tmp = Util.parseCommaDelimitedLongs(propertyValue);
            if (tmp != null && tmp.length > 0) {
                return tmp;
            }
            return null;
        }

        @Override
        public String toString(Object value) {
            if (value == null) {
                return null;
            }
            long[] val = (long[])value;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (long l : val) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(l);
            }
            return sb.toString();
        }
    }

    public static class IntegerArray
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope) throws Exception {
            int[] tmp = Util.parseCommaDelimitedInts(propertyValue);
            if (tmp != null && tmp.length > 0) {
                return tmp;
            }
            return null;
        }

        @Override
        public String toString(Object value) {
            if (value == null) {
                return null;
            }
            int[] val = (int[])value;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (int l : val) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(l);
            }
            return sb.toString();
        }
    }

    public static class BindInterface
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope) throws Exception {
            InetAddress old_bind_addr = (InetAddress)Configurator.getValueFromProtocol((Protocol)obj, "bind_addr");
            InetAddress new_bind_addr = Util.validateBindAddressFromInterface(old_bind_addr, propertyValue);
            if (new_bind_addr != null) {
                BindInterface.setBindAddress((Protocol)obj, new_bind_addr);
            }
            if (propertyValue != null) {
                return propertyValue;
            }
            return "";
        }

        private static void setBindAddress(Protocol protocol, InetAddress bind_addr) throws Exception {
            Field f = Util.getField(protocol.getClass(), "bind_addr");
            Util.setField(f, protocol, bind_addr);
        }

        @Override
        public String toString(Object value) {
            return (String)value;
        }
    }

    public static class InitialHosts2
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String prop_val, boolean check_scope) throws Exception {
            return Util.parseCommaDelimitedHosts2(prop_val, 1);
        }

        @Override
        public String toString(Object value) {
            if (value instanceof Collection) {
                StringBuilder sb = new StringBuilder();
                Collection list = (Collection)value;
                boolean first = true;
                for (InetSocketAddress addr : list) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(addr.getAddress().getHostAddress()).append("[").append(addr.getPort()).append("]");
                }
                return sb.toString();
            }
            return value.getClass().getName();
        }
    }

    public static class InitialHosts
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String prop_val, boolean check_scope) throws Exception {
            int port_range = InitialHosts.getPortRange((Protocol)obj);
            return Util.parseCommaDelimitedHosts(prop_val, port_range);
        }

        @Override
        public String toString(Object value) {
            if (value instanceof Collection) {
                StringBuilder sb = new StringBuilder();
                Collection list = (Collection)value;
                boolean first = true;
                for (IpAddress addr : list) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(addr.getIpAddress().getHostAddress()).append("[").append(addr.getPort()).append("]");
                }
                return sb.toString();
            }
            return value.getClass().getName();
        }

        private static int getPortRange(Protocol protocol) throws Exception {
            Field f = protocol.getClass().getDeclaredField("port_range");
            return (Integer)Util.getField(f, protocol);
        }
    }

    public static class FlushInvoker
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope) throws Exception {
            if (propertyValue == null) {
                return null;
            }
            Class<?> invoker = Class.forName(propertyValue);
            invoker.getDeclaredConstructor(View.class);
            return invoker;
        }

        @Override
        public String toString(Object value) {
            return value.getClass().getName();
        }
    }

    public static class NetworkInterfaceList
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope) throws Exception {
            return Util.parseInterfaceList(propertyValue);
        }

        @Override
        public String toString(Object value) {
            List list = (List)value;
            return Util.print(list);
        }
    }
}

