/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.ClientWatchManager;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Environment;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.CreateResponse;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.ExistsRequest;
import org.apache.zookeeper.proto.GetACLRequest;
import org.apache.zookeeper.proto.GetACLResponse;
import org.apache.zookeeper.proto.GetChildren2Request;
import org.apache.zookeeper.proto.GetChildren2Response;
import org.apache.zookeeper.proto.GetChildrenRequest;
import org.apache.zookeeper.proto.GetChildrenResponse;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.proto.GetDataResponse;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.proto.SetACLRequest;
import org.apache.zookeeper.proto.SetACLResponse;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.proto.SetDataResponse;
import org.apache.zookeeper.proto.SyncRequest;
import org.apache.zookeeper.proto.SyncResponse;
import org.apache.zookeeper.server.DataTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooKeeper {
    private static final Logger LOG = Logger.getLogger(ZooKeeper.class);
    private final ZKWatchManager watchManager = new ZKWatchManager();
    volatile States state;
    protected final ClientCnxn cnxn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getDataWatches() {
        Map map = this.watchManager.dataWatches;
        synchronized (map) {
            ArrayList<String> rc = new ArrayList<String>(this.watchManager.dataWatches.keySet());
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getExistWatches() {
        Map map = this.watchManager.existWatches;
        synchronized (map) {
            ArrayList<String> rc = new ArrayList<String>(this.watchManager.existWatches.keySet());
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getChildWatches() {
        Map map = this.watchManager.childWatches;
        synchronized (map) {
            ArrayList<String> rc = new ArrayList<String>(this.watchManager.childWatches.keySet());
            return rc;
        }
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
        LOG.info((Object)("Initiating client connection, connectString=" + connectString + " sessionTimeout=" + sessionTimeout + " watcher=" + watcher));
        this.watchManager.defaultWatcher = watcher;
        this.cnxn = new ClientCnxn(connectString, sessionTimeout, this, this.watchManager);
        this.cnxn.start();
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher, long sessionId, byte[] sessionPasswd) throws IOException {
        LOG.info((Object)("Initiating client connection, connectString=" + connectString + " sessionTimeout=" + sessionTimeout + " watcher=" + watcher + " sessionId=" + sessionId + " sessionPasswd=" + (sessionPasswd == null ? "<null>" : "<hidden>")));
        this.watchManager.defaultWatcher = watcher;
        this.cnxn = new ClientCnxn(connectString, sessionTimeout, this, this.watchManager, sessionId, sessionPasswd);
        this.cnxn.start();
    }

    public long getSessionId() {
        return this.cnxn.getSessionId();
    }

    public byte[] getSessionPasswd() {
        return this.cnxn.getSessionPasswd();
    }

    public int getSessionTimeout() {
        return this.cnxn.getSessionTimeout();
    }

    public void addAuthInfo(String scheme, byte[] auth) {
        this.cnxn.addAuthInfo(scheme, auth);
    }

    public synchronized void register(Watcher watcher) {
        this.watchManager.defaultWatcher = watcher;
    }

    public synchronized void close() throws InterruptedException {
        block5: {
            if (!this.state.isAlive()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Close called on already closed client");
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closing session: 0x" + Long.toHexString(this.getSessionId())));
            }
            try {
                this.cnxn.close();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)"Ignoring unexpected exception during close", (Throwable)e);
            }
        }
        LOG.info((Object)("Session: 0x" + Long.toHexString(this.getSessionId()) + " closed"));
    }

    private String prependChroot(String clientPath) {
        if (this.cnxn.chrootPath != null) {
            if (clientPath.length() == 1) {
                return this.cnxn.chrootPath;
            }
            return this.cnxn.chrootPath + clientPath;
        }
        return clientPath;
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        String clientPath = path;
        PathUtils.validatePath(clientPath, createMode.isSequential());
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(1);
        CreateRequest request = new CreateRequest();
        CreateResponse response = new CreateResponse();
        request.setData(data);
        request.setFlags(createMode.toFlag());
        request.setPath(serverPath);
        if (acl != null && acl.size() == 0) {
            throw new KeeperException.InvalidACLException();
        }
        request.setAcl(acl);
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        if (this.cnxn.chrootPath == null) {
            return response.getPath();
        }
        return response.getPath().substring(this.cnxn.chrootPath.length());
    }

    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        String clientPath = path;
        PathUtils.validatePath(clientPath, createMode.isSequential());
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(1);
        CreateRequest request = new CreateRequest();
        CreateResponse response = new CreateResponse();
        ReplyHeader r = new ReplyHeader();
        request.setData(data);
        request.setFlags(createMode.toFlag());
        request.setPath(serverPath);
        request.setAcl(acl);
        this.cnxn.queuePacket(h, r, request, response, cb, clientPath, serverPath, ctx, null);
    }

    public void delete(String path, int version) throws InterruptedException, KeeperException {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        String serverPath = clientPath.equals("/") ? clientPath : this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(2);
        DeleteRequest request = new DeleteRequest();
        request.setPath(serverPath);
        request.setVersion(version);
        ReplyHeader r = this.cnxn.submitRequest(h, request, null, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
    }

    public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        String serverPath = clientPath.equals("/") ? clientPath : this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(2);
        DeleteRequest request = new DeleteRequest();
        request.setPath(serverPath);
        request.setVersion(version);
        this.cnxn.queuePacket(h, new ReplyHeader(), request, null, cb, clientPath, serverPath, ctx, null);
    }

    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        ExistsWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ExistsWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(3);
        ExistsRequest request = new ExistsRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        SetDataResponse response = new SetDataResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, wcb);
        if (r.getErr() != 0) {
            if (r.getErr() == KeeperException.Code.NONODE.intValue()) {
                return null;
            }
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        return response.getStat().getCzxid() == -1L ? null : response.getStat();
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.exists(path, watch ? this.watchManager.defaultWatcher : null);
    }

    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        ExistsWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ExistsWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(3);
        ExistsRequest request = new ExistsRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        SetDataResponse response = new SetDataResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, wcb);
    }

    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.exists(path, watch ? this.watchManager.defaultWatcher : null, cb, ctx);
    }

    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        DataWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new DataWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(4);
        GetDataRequest request = new GetDataRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetDataResponse response = new GetDataResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, wcb);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        if (stat != null) {
            DataTree.copyStat(response.getStat(), stat);
        }
        return response.getData();
    }

    public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.getData(path, watch ? this.watchManager.defaultWatcher : null, stat);
    }

    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        DataWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new DataWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(4);
        GetDataRequest request = new GetDataRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetDataResponse response = new GetDataResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, wcb);
    }

    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.getData(path, watch ? this.watchManager.defaultWatcher : null, cb, ctx);
    }

    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(5);
        SetDataRequest request = new SetDataRequest();
        request.setPath(serverPath);
        request.setData(data);
        request.setVersion(version);
        SetDataResponse response = new SetDataResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        return response.getStat();
    }

    public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(5);
        SetDataRequest request = new SetDataRequest();
        request.setPath(serverPath);
        request.setData(data);
        request.setVersion(version);
        SetDataResponse response = new SetDataResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, null);
    }

    public List<ACL> getACL(String path, Stat stat) throws KeeperException, InterruptedException {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(6);
        GetACLRequest request = new GetACLRequest();
        request.setPath(serverPath);
        GetACLResponse response = new GetACLResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        DataTree.copyStat(response.getStat(), stat);
        return response.getAcl();
    }

    public void getACL(String path, Stat stat, AsyncCallback.ACLCallback cb, Object ctx) {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(6);
        GetACLRequest request = new GetACLRequest();
        request.setPath(serverPath);
        GetACLResponse response = new GetACLResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, null);
    }

    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(7);
        SetACLRequest request = new SetACLRequest();
        request.setPath(serverPath);
        if (acl != null && acl.size() == 0) {
            throw new KeeperException.InvalidACLException();
        }
        request.setAcl(acl);
        request.setVersion(version);
        SetACLResponse response = new SetACLResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        return response.getStat();
    }

    public void setACL(String path, List<ACL> acl, int version, AsyncCallback.StatCallback cb, Object ctx) {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(7);
        SetACLRequest request = new SetACLRequest();
        request.setPath(serverPath);
        request.setAcl(acl);
        request.setVersion(version);
        SetACLResponse response = new SetACLResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, null);
    }

    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        ChildWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ChildWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(8);
        GetChildrenRequest request = new GetChildrenRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetChildrenResponse response = new GetChildrenResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, wcb);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        return response.getChildren();
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.getChildren(path, watch ? this.watchManager.defaultWatcher : null);
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        ChildWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ChildWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(8);
        GetChildrenRequest request = new GetChildrenRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetChildrenResponse response = new GetChildrenResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, wcb);
    }

    public void getChildren(String path, boolean watch, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.getChildren(path, watch ? this.watchManager.defaultWatcher : null, cb, ctx);
    }

    public List<String> getChildren(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        ChildWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ChildWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(12);
        GetChildren2Request request = new GetChildren2Request();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetChildren2Response response = new GetChildren2Response();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, wcb);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        if (stat != null) {
            DataTree.copyStat(response.getStat(), stat);
        }
        return response.getChildren();
    }

    public List<String> getChildren(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.getChildren(path, watch ? this.watchManager.defaultWatcher : null, stat);
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        ChildWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ChildWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(12);
        GetChildren2Request request = new GetChildren2Request();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetChildren2Response response = new GetChildren2Response();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, wcb);
    }

    public void getChildren(String path, boolean watch, AsyncCallback.Children2Callback cb, Object ctx) {
        this.getChildren(path, watch ? this.watchManager.defaultWatcher : null, cb, ctx);
    }

    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        String clientPath = path;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(9);
        SyncRequest request = new SyncRequest();
        SyncResponse response = new SyncResponse();
        request.setPath(serverPath);
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, null);
    }

    public States getState() {
        return this.state;
    }

    public String toString() {
        States state = this.getState();
        return "State:" + state.toString() + (state == States.CONNECTED ? " Timeout:" + this.getSessionTimeout() + " " : " ") + this.cnxn;
    }

    protected boolean testableWaitForShutdown(int wait) throws InterruptedException {
        this.cnxn.sendThread.join(wait);
        if (this.cnxn.sendThread.isAlive()) {
            return false;
        }
        this.cnxn.eventThread.join(wait);
        return !this.cnxn.eventThread.isAlive();
    }

    protected SocketAddress testableRemoteSocketAddress() {
        return this.cnxn.getRemoteSocketAddress();
    }

    protected SocketAddress testableLocalSocketAddress() {
        return this.cnxn.getLocalSocketAddress();
    }

    static {
        Environment.logEnv("Client environment:", LOG);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum States {
        CONNECTING,
        ASSOCIATING,
        CONNECTED,
        CLOSED,
        AUTH_FAILED;


        public boolean isAlive() {
            return this != CLOSED && this != AUTH_FAILED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildWatchRegistration
    extends WatchRegistration {
        public ChildWatchRegistration(Watcher watcher, String clientPath) {
            super(watcher, clientPath);
        }

        @Override
        protected Map<String, Set<Watcher>> getWatches(int rc) {
            return ZooKeeper.this.watchManager.childWatches;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DataWatchRegistration
    extends WatchRegistration {
        public DataWatchRegistration(Watcher watcher, String clientPath) {
            super(watcher, clientPath);
        }

        @Override
        protected Map<String, Set<Watcher>> getWatches(int rc) {
            return ZooKeeper.this.watchManager.dataWatches;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExistsWatchRegistration
    extends WatchRegistration {
        public ExistsWatchRegistration(Watcher watcher, String clientPath) {
            super(watcher, clientPath);
        }

        @Override
        protected Map<String, Set<Watcher>> getWatches(int rc) {
            return rc == 0 ? ZooKeeper.this.watchManager.dataWatches : ZooKeeper.this.watchManager.existWatches;
        }

        @Override
        protected boolean shouldAddWatch(int rc) {
            return rc == 0 || rc == KeeperException.Code.NONODE.intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class WatchRegistration {
        private Watcher watcher;
        private String clientPath;

        public WatchRegistration(Watcher watcher, String clientPath) {
            this.watcher = watcher;
            this.clientPath = clientPath;
        }

        protected abstract Map<String, Set<Watcher>> getWatches(int var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(int rc) {
            if (this.shouldAddWatch(rc)) {
                Map<String, Set<Watcher>> watches;
                Map<String, Set<Watcher>> map = watches = this.getWatches(rc);
                synchronized (map) {
                    Set<Watcher> watchers = watches.get(this.clientPath);
                    if (watchers == null) {
                        watchers = new HashSet<Watcher>();
                        watches.put(this.clientPath, watchers);
                    }
                    watchers.add(this.watcher);
                }
            }
        }

        protected boolean shouldAddWatch(int rc) {
            return rc == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZKWatchManager
    implements ClientWatchManager {
        private final Map<String, Set<Watcher>> dataWatches = new HashMap<String, Set<Watcher>>();
        private final Map<String, Set<Watcher>> existWatches = new HashMap<String, Set<Watcher>>();
        private final Map<String, Set<Watcher>> childWatches = new HashMap<String, Set<Watcher>>();
        private volatile Watcher defaultWatcher;

        private ZKWatchManager() {
        }

        private final void addTo(Set<Watcher> from, Set<Watcher> to) {
            if (from != null) {
                to.addAll(from);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Watcher> materialize(Watcher.Event.KeeperState state, Watcher.Event.EventType type, String clientPath) {
            HashSet<Watcher> result = new HashSet<Watcher>();
            switch (type) {
                case None: {
                    result.add(this.defaultWatcher);
                    for (Set<Watcher> ws : this.dataWatches.values()) {
                        result.addAll(ws);
                    }
                    for (Set<Watcher> ws : this.existWatches.values()) {
                        result.addAll(ws);
                    }
                    for (Set<Watcher> ws : this.childWatches.values()) {
                        result.addAll(ws);
                    }
                    if (ClientCnxn.getDisableAutoResetWatch() && state != Watcher.Event.KeeperState.SyncConnected) {
                        Map<String, Set<Watcher>> i$ = this.dataWatches;
                        synchronized (i$) {
                            this.dataWatches.clear();
                        }
                        i$ = this.existWatches;
                        synchronized (i$) {
                            this.existWatches.clear();
                        }
                        i$ = this.childWatches;
                        synchronized (i$) {
                            this.childWatches.clear();
                        }
                    }
                    return result;
                }
                case NodeDataChanged: 
                case NodeCreated: {
                    Map<String, Set<Watcher>> i$ = this.dataWatches;
                    synchronized (i$) {
                        this.addTo(this.dataWatches.remove(clientPath), result);
                    }
                    i$ = this.existWatches;
                    synchronized (i$) {
                        this.addTo(this.existWatches.remove(clientPath), result);
                        break;
                    }
                }
                case NodeChildrenChanged: {
                    Map<String, Set<Watcher>> i$ = this.childWatches;
                    synchronized (i$) {
                        this.addTo(this.childWatches.remove(clientPath), result);
                        break;
                    }
                }
                case NodeDeleted: {
                    Map<String, Set<Watcher>> i$ = this.dataWatches;
                    synchronized (i$) {
                        this.addTo(this.dataWatches.remove(clientPath), result);
                    }
                    i$ = this.existWatches;
                    synchronized (i$) {
                        Set<Watcher> list = this.existWatches.remove(clientPath);
                        if (list != null) {
                            this.addTo(this.existWatches.remove(clientPath), result);
                            LOG.warn((Object)"We are triggering an exists watch for delete! Shouldn't happen!");
                        }
                    }
                    i$ = this.childWatches;
                    synchronized (i$) {
                        this.addTo(this.childWatches.remove(clientPath), result);
                        break;
                    }
                }
                default: {
                    String msg = "Unhandled watch event type " + (Object)((Object)type) + " with state " + (Object)((Object)state) + " on path " + clientPath;
                    LOG.error((Object)msg);
                    throw new RuntimeException(msg);
                }
            }
            return result;
        }
    }
}

