/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.builder.service.PostBuildHandler;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectRepositories;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectRepositoriesService;
import org.guvnor.common.services.project.service.ProjectRepositoryResolver;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.services.backend.builder.Builder;
import org.kie.workbench.common.services.backend.builder.LRUBuilderCache;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@Service
@ApplicationScoped
public class BuildServiceImpl
implements BuildService {
    private static final Logger logger = LoggerFactory.getLogger(BuildServiceImpl.class);
    private POMService pomService;
    private ExtendedM2RepoService m2RepoService;
    private KieProjectService projectService;
    private ProjectRepositoryResolver repositoryResolver;
    private ProjectRepositoriesService projectRepositoriesService;
    private LRUBuilderCache cache;
    private Instance<PostBuildHandler> handlers;
    @Inject
    protected Instance<User> identity;

    public BuildServiceImpl() {
    }

    @Inject
    public BuildServiceImpl(POMService pomService, ExtendedM2RepoService m2RepoService, KieProjectService projectService, ProjectRepositoryResolver repositoryResolver, ProjectRepositoriesService projectRepositoriesService, LRUBuilderCache cache, Instance<PostBuildHandler> handlers) {
        this.pomService = pomService;
        this.m2RepoService = m2RepoService;
        this.projectService = projectService;
        this.repositoryResolver = repositoryResolver;
        this.projectRepositoriesService = projectRepositoriesService;
        this.cache = cache;
        this.handlers = handlers;
    }

    public BuildResults build(Project project) {
        return this.build(project, () -> {
            Builder builder = this.cache.assertBuilder(project);
            return builder.build();
        });
    }

    public BuildResults buildAndDeploy(Project project) {
        return this.buildAndDeploy(project, DeploymentMode.VALIDATED);
    }

    public BuildResults buildAndDeploy(Project project, DeploymentMode mode) {
        if (DeploymentMode.VALIDATED.equals((Object)mode)) {
            this.checkRepositories(project);
        }
        return this.doBuildAndDeploy(project, false);
    }

    public BuildResults buildAndDeploy(Project project, boolean suppressHandlers) {
        return this.buildAndDeploy(project, suppressHandlers, DeploymentMode.VALIDATED);
    }

    public BuildResults buildAndDeploy(Project project, boolean suppressHandlers, DeploymentMode mode) {
        if (DeploymentMode.VALIDATED.equals((Object)mode)) {
            this.checkRepositories(project);
        }
        return this.doBuildAndDeploy(project, suppressHandlers);
    }

    private BuildResults doBuildAndDeploy(Project project, boolean suppressHandlers) {
        try {
            BuildResults results = this.doBuild(project);
            StringBuffer message = new StringBuffer();
            message.append("Build of project '" + project.getProjectName() + "' (requested by " + this.getIdentifier() + ") completed.\n");
            message.append(" Build: " + (results.getErrorMessages().isEmpty() ? "SUCCESSFUL" : "FAILURE"));
            POM pom = (POM)this.pomService.load(project.getPomXMLPath());
            if (results.getErrorMessages().isEmpty()) {
                Builder builder = this.cache.assertBuilder(project);
                InternalKieModule kieModule = (InternalKieModule)builder.getKieModule();
                ByteArrayInputStream input = new ByteArrayInputStream(kieModule.getBytes());
                this.m2RepoService.deployJar((InputStream)input, pom.getGav());
                message.append(" Maven: SUCCESSFUL");
                if (!suppressHandlers) {
                    for (PostBuildHandler handler : this.handlers) {
                        try {
                            handler.process(results);
                        }
                        catch (Exception e) {
                            logger.warn("PostBuildHandler {} failed due to {}", (Object)handler, (Object)e.getMessage());
                        }
                    }
                    message.append(" Deploy: " + (results.getErrorMessages().isEmpty() ? "SUCCESSFUL" : "FAILURE"));
                }
            }
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.buildExceptionResults(e, project.getPom().getGav());
        }
    }

    private void checkRepositories(Project project) {
        GAV gav = project.getPom().getGav();
        if (gav.isSnapshot()) {
            return;
        }
        ProjectRepositories projectRepositories = (ProjectRepositories)this.projectRepositoriesService.load(((KieProject)project).getRepositoriesPath());
        Set repositories = this.repositoryResolver.getRepositoriesResolvingArtifact(gav, projectRepositories.filterByIncluded());
        if (repositories.size() > 0) {
            throw new GAVAlreadyExistsException(gav, repositories);
        }
    }

    private BuildResults buildExceptionResults(Exception e, GAV gav) {
        BuildResults exceptionResults = new BuildResults(gav);
        BuildMessage exceptionMessage = new BuildMessage();
        exceptionMessage.setLevel(Level.ERROR);
        exceptionMessage.setText(e.getMessage());
        exceptionResults.addBuildMessage(exceptionMessage);
        return exceptionResults;
    }

    private BuildResults doBuild(Project project) {
        this.cache.invalidateCache(project);
        Builder builder = this.cache.assertBuilder(project);
        BuildResults results = builder.build();
        return results;
    }

    private BuildResults build(Project project, Supplier<BuildResults> buildResultsSupplier) {
        try {
            this.cache.invalidateCache(project);
            BuildResults results = buildResultsSupplier.get();
            BuildMessage infoMsg = new BuildMessage();
            infoMsg.setLevel(Level.INFO);
            infoMsg.setText(this.buildResultMessage(project, results).toString());
            results.addBuildMessage(0, infoMsg);
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.buildExceptionResults(e, project.getPom().getGav());
        }
    }

    private StringBuffer buildResultMessage(Project project, BuildResults results) {
        StringBuffer message = new StringBuffer();
        message.append("Build of project '");
        message.append(project.getProjectName());
        message.append("' (requested by ");
        message.append(this.getIdentifier());
        message.append(") completed.\n");
        message.append(" Build: ");
        message.append(results.getErrorMessages().isEmpty() ? "SUCCESSFUL" : "FAILURE");
        return message;
    }

    public boolean isBuilt(Project project) {
        Builder builder = this.cache.assertBuilder(project);
        return builder.isBuilt();
    }

    public IncrementalBuildResults addPackageResource(Path resource) {
        try {
            IncrementalBuildResults results = new IncrementalBuildResults();
            KieProject project = (KieProject)this.projectService.resolveProject(resource);
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder((Project)project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.addResource(Paths.convert((Path)resource));
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults deletePackageResource(Path resource) {
        try {
            IncrementalBuildResults results = new IncrementalBuildResults();
            KieProject project = (KieProject)this.projectService.resolveProject(resource);
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder((Project)project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.deleteResource(Paths.convert((Path)resource));
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults updatePackageResource(Path resource) {
        return this.updatePackageResource(resource, builder -> builder.updateResource(Paths.convert((Path)resource)));
    }

    private IncrementalBuildResults updatePackageResource(Path resource, Function<Builder, IncrementalBuildResults> updateResourceAndBuild) {
        try {
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return new IncrementalBuildResults();
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            return updateResourceAndBuild.apply(builder);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults applyBatchResourceChanges(Project project, Map<Path, Collection<ResourceChange>> changes) {
        IncrementalBuildResults results = new IncrementalBuildResults();
        try {
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.applyBatchResourceChanges(changes);
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected String getIdentifier() {
        if (this.identity.isUnsatisfied()) {
            return "system";
        }
        try {
            return ((User)this.identity.get()).getIdentifier();
        }
        catch (ContextNotActiveException e) {
            return "system";
        }
    }

    LRUBuilderCache getCache() {
        return this.cache;
    }
}

