/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugin;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.bus.server.api.RpcContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.plugin.RuntimePluginService;
import org.uberfire.backend.server.plugin.GwtRuntimePluginManager;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;

@Service
@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class RuntimePluginServiceImpl
implements RuntimePluginService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimePluginServiceImpl.class);
    private static RuntimePluginServiceImpl instance;
    @Inject
    private GwtRuntimePluginManager gwtRuntimePluginManager;

    @PostConstruct
    private void startUp() {
        instance = this;
    }

    public static RuntimePluginServiceImpl getInstance() {
        if (instance == null) {
            throw new IllegalStateException(RuntimePluginService.class.getName() + " was not initialized on startup");
        }
        return instance;
    }

    public void init(ServletContext servletContext) {
        String contextRootDir = this.getRealPath(servletContext, File.separator);
        String pluginDir = this.getRealPath(servletContext, "plugins");
        if (contextRootDir != null && pluginDir != null) {
            this.gwtRuntimePluginManager.init(contextRootDir, pluginDir);
        }
    }

    public Collection<String> listFramworksContent() {
        return this.directoryContent("frameworks", "*.js");
    }

    public Collection<String> listPluginsContent() {
        return this.directoryContent("plugins", "*.js");
    }

    public String getTemplateContent(String url) {
        String realPath = this.getRealPath("plugins");
        if (realPath == null) {
            LOGGER.info("Not fetching template content for " + url + " because getRealPath() is returning null. (This app is probably deployed in an unexploded .war)");
            return "";
        }
        Path template = url.startsWith("/") ? Paths.get((URI)URI.create("file://" + realPath + url)) : Paths.get((URI)URI.create("file://" + realPath + "/" + url));
        if (Files.isRegularFile((Path)template, (LinkOption[])new LinkOption[0])) {
            return new String(Files.readAllBytes((Path)template));
        }
        return "";
    }

    private Collection<String> directoryContent(String directory, String glob) {
        String realPath = this.getRealPath(directory);
        if (realPath == null) {
            LOGGER.info("Not listing directory content for " + directory + "/" + glob + " because getRealPath() is returning null. (This app is probably deployed in an unexploded .war)");
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Path pluginsRootPath = Paths.get((URI)URI.create("file://" + realPath));
        if (Files.isDirectory((Path)pluginsRootPath, (LinkOption[])new LinkOption[0])) {
            DirectoryStream stream = Files.newDirectoryStream((Path)pluginsRootPath, (String)glob);
            for (Path activeJS : stream) {
                result.add(new String(Files.readAllBytes((Path)activeJS)));
            }
        }
        return result;
    }

    private String getRealPath(String path) {
        return this.getRealPath(RpcContext.getServletRequest().getServletContext(), path);
    }

    private String getRealPath(ServletContext servletContext, String path) {
        String realPath = servletContext.getRealPath(path);
        if (realPath == null) {
            return null;
        }
        return realPath.replaceAll("\\\\", "/").replaceAll(" ", "%20");
    }
}

