/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;

public class RoleRegistry {
    private Set<Role> roles = new HashSet<Role>();
    private static RoleRegistry instance = null;

    private RoleRegistry() {
    }

    public static RoleRegistry get() {
        if (instance == null) {
            instance = new RoleRegistry();
        }
        return instance;
    }

    public void registerRole(String role) {
        this.roles.add((Role)new RoleImpl(role));
    }

    public Role getRegisteredRole(String name) {
        for (Role role : this.roles) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public Set<Role> getRegisteredRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public void clear() {
        this.roles.clear();
    }
}

