/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.processors;

import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import org.uberfire.ext.preferences.shared.PropertyFormType;
import org.uberfire.ext.preferences.shared.annotations.Property;
import org.uberfire.ext.preferences.shared.annotations.WorkbenchPreference;

public class PropertyData {
    private String fieldName;
    private String capitalizedFieldName;
    private String typeFullName;
    private boolean shared;
    private boolean subPreference;
    private PropertyFormType formType;
    private boolean privateAccess;
    private TypeKind typeKind;

    public PropertyData(Element element, Property propertyAnnotation, Elements elementUtils) {
        this.fieldName = element.getSimpleName().toString();
        this.typeFullName = element.asType().toString();
        char elementNameFirstLetter = this.fieldName.charAt(0);
        char elementNameCapitalizedFirstLetter = Character.toUpperCase(elementNameFirstLetter);
        String nameWithoutFirstLetter = this.fieldName.substring(1);
        this.capitalizedFieldName = elementNameCapitalizedFirstLetter + nameWithoutFirstLetter;
        this.shared = propertyAnnotation.shared();
        TypeElement typeElement = elementUtils.getTypeElement(element.asType().toString());
        this.subPreference = typeElement != null && typeElement.getAnnotation(WorkbenchPreference.class) != null;
        this.formType = propertyAnnotation.formType();
        this.privateAccess = element.getModifiers().contains((Object)Modifier.PRIVATE);
        this.typeKind = element.asType().getKind();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getCapitalizedFieldName() {
        return this.capitalizedFieldName;
    }

    public String getTypeFullName() {
        return this.typeFullName;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean isSubPreference() {
        return this.subPreference;
    }

    public PropertyFormType getFormType() {
        return this.formType;
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public boolean isPrimitive() {
        return this.typeKind.isPrimitive();
    }

    public String getHashCodeFormula() {
        if (this.isPrimitive()) {
            switch (this.typeKind) {
                case BOOLEAN: {
                    return "java.lang.Boolean.hashCode( " + this.getFieldAccessorCommand() + " )";
                }
                case BYTE: {
                    return "java.lang.Byte.hashCode( " + this.getFieldAccessorCommand() + " )";
                }
                case SHORT: {
                    return "java.lang.Short.hashCode( " + this.getFieldAccessorCommand() + " )";
                }
                case INT: {
                    return "java.lang.Integer.hashCode( " + this.getFieldAccessorCommand() + " )";
                }
                case LONG: {
                    return "java.lang.Long.hashCode( " + this.getFieldAccessorCommand() + " )";
                }
                case CHAR: {
                    return "java.lang.Character.hashCode( " + this.getFieldAccessorCommand() + " )";
                }
                case FLOAT: {
                    return "java.lang.Float.hashCode( " + this.getFieldAccessorCommand() + " )";
                }
                case DOUBLE: {
                    return "java.lang.Double.hashCode( " + this.getFieldAccessorCommand() + " )";
                }
            }
        }
        return "( " + this.getFieldAccessorCommand() + " != null ? " + this.getFieldAccessorCommand() + ".hashCode() : 0 )";
    }

    public String getFieldAccessorCommand() {
        if (!this.isPrivateAccess()) {
            return this.fieldName;
        }
        if (this.isPrimitive() && TypeKind.BOOLEAN.equals((Object)this.typeKind)) {
            return "is" + this.capitalizedFieldName + "()";
        }
        return "get" + this.capitalizedFieldName + "()";
    }
}

