/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SearchEmptyQueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.RuleNameResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.AbstractFindQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePackageNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueProjectRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.ResourceType;

@ApplicationScoped
public class FindRulesByProjectQuery
extends AbstractFindQuery
implements NamedQuery {
    public static String NAME = "FindRulesByProjectQuery";
    @Inject
    private RuleNameResponseBuilder responseBuilder;
    private static final ValueResourceIndexTerm ruleTerm = new ValueResourceIndexTerm("not-used", ResourceType.RULE);

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms) {
        this.checkNotNullAndNotEmpty(terms);
        ValuePackageNameIndexTerm packageTerm = null;
        ValueProjectRootPathIndexTerm projectTerm = null;
        ValueResourceIndexTerm ruleTerm = null;
        for (ValueIndexTerm term : terms) {
            if (term instanceof ValuePackageNameIndexTerm) {
                packageTerm = (ValuePackageNameIndexTerm)term;
                continue;
            }
            if (term instanceof ValueProjectRootPathIndexTerm) {
                projectTerm = (ValueProjectRootPathIndexTerm)term;
                continue;
            }
            if (!(term instanceof ValueResourceIndexTerm)) continue;
            ruleTerm = (ValueResourceIndexTerm)term;
        }
        SearchEmptyQueryBuilder queryBuilder = new SearchEmptyQueryBuilder().addTerm((ValueIndexTerm)packageTerm).addTerm((ValueIndexTerm)projectTerm);
        if (ruleTerm != null) {
            queryBuilder.addTerm((ValueIndexTerm)ruleTerm);
        } else {
            queryBuilder.addRuleNameWildCardTerm();
        }
        return queryBuilder.build();
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    @Override
    public void validateTerms(Set<ValueIndexTerm> queryTerms) throws IllegalArgumentException {
        this.checkInvalidAndRequiredTerms(queryTerms, NAME, new String[]{"packageName", "projectRoot", null}, t -> t instanceof ValuePackageNameIndexTerm, t -> t instanceof ValueProjectRootPathIndexTerm, t -> t.getTerm().equals(ruleTerm.getTerm()));
        this.checkTermsSize(2, queryTerms);
    }
}

