/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.forge.roaster.model.SyntaxError;
import org.kie.workbench.common.screens.datamodeller.model.DataModelerError;
import org.kie.workbench.common.services.datamodeller.driver.model.DriverError;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DataModelerServiceHelper {
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    @Inject
    protected KieProjectService projectService;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;

    public List<DataModelerError> toDataModelerError(List<DriverError> errors) {
        ArrayList<DataModelerError> result = new ArrayList<DataModelerError>();
        if (errors == null) {
            return result;
        }
        for (DriverError error : errors) {
            DataModelerError dataModelerError = new DataModelerError(error.getId(), error.getMessage(), Level.ERROR, error.getFile(), error.getLine(), error.getColumn());
            result.add(dataModelerError);
        }
        return result;
    }

    public List<DataModelerError> toDataModelerError(List<SyntaxError> syntaxErrors, Path file) {
        ArrayList<DataModelerError> errors = new ArrayList<DataModelerError>();
        for (SyntaxError syntaxError : syntaxErrors) {
            DataModelerError error = new DataModelerError(syntaxError.getDescription(), syntaxError.isError() ? Level.ERROR : Level.WARNING, Paths.convert((Path)file));
            error.setColumn(syntaxError.getColumn());
            error.setLine(syntaxError.getLine());
            errors.add(error);
        }
        return errors;
    }

    public Map<String, org.uberfire.backend.vfs.Path> toVFSPaths(Map<String, Path> nioPaths) {
        HashMap<String, org.uberfire.backend.vfs.Path> vfsPaths = new HashMap<String, org.uberfire.backend.vfs.Path>();
        if (nioPaths != null) {
            for (String key : nioPaths.keySet()) {
                vfsPaths.put(key, Paths.convert((Path)nioPaths.get(key)));
            }
        }
        return vfsPaths;
    }

    public List<ValidationMessage> toValidationMessage(List<DataModelerError> errors) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        if (errors == null) {
            return validationMessages;
        }
        for (DataModelerError error : errors) {
            ValidationMessage validationMessage = new ValidationMessage();
            validationMessage.setPath(error.getFile());
            validationMessage.setText(error.getMessage());
            validationMessage.setColumn(error.getColumn());
            validationMessage.setLine(error.getLine());
            validationMessage.setId(error.getId());
            if (error.getLevel() != null) {
                validationMessage.setLevel(error.getLevel());
            }
            validationMessages.add(validationMessage);
        }
        return validationMessages;
    }

    public CommentedOption makeCommentedOption(String commitMessage) {
        return this.commentedOptionFactory.makeCommentedOption(commitMessage);
    }

    public Package ensurePackageStructure(Project project, String packageName) {
        Package defaultPackage;
        if (packageName == null || "".equals(packageName) || project == null) {
            return null;
        }
        Package subPackage = defaultPackage = this.projectService.resolveDefaultPackage(project);
        Path subDirPath = Paths.convert((org.uberfire.backend.vfs.Path)defaultPackage.getPackageMainSrcPath());
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        while (tokenizer.hasMoreTokens()) {
            String subDirName = tokenizer.nextToken();
            if (!this.ioService.exists(subDirPath = subDirPath.resolve(subDirName))) {
                subPackage = this.projectService.newPackage(subPackage, subDirName);
                continue;
            }
            subPackage = this.projectService.resolvePackage(Paths.convert((Path)subDirPath));
        }
        return subPackage;
    }

    public String getCanonicalFileName(org.uberfire.backend.vfs.Path path) {
        if (path == null) {
            return null;
        }
        String fileName = path.getFileName();
        return fileName.substring(0, fileName.indexOf("."));
    }

    public Set<String> resolvePackages(KieProject project) {
        HashSet<String> packages = new HashSet<String>();
        Path rootPath = Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath());
        String[] subdirs = "src/main/java".split("/");
        Path javaDir = rootPath;
        for (String subdir : subdirs) {
            if (this.ioService.exists(javaDir = javaDir.resolve(subdir))) continue;
            javaDir = null;
            break;
        }
        if (javaDir == null) {
            return packages;
        }
        String javaDirURI = javaDir.toUri().toString();
        ArrayList<Path> childDirectories = new ArrayList<Path>();
        childDirectories.add(javaDir);
        while (childDirectories.size() > 0) {
            DirectoryStream dirStream = this.ioService.newDirectoryStream((Path)childDirectories.remove(0), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

                public boolean accept(Path entry) throws IOException {
                    return Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]);
                }
            });
            Iterator it = dirStream.iterator();
            while (it != null && it.hasNext()) {
                Path subDir = (Path)it.next();
                childDirectories.add(subDir);
                packages.add(this.getPackagePart(javaDirURI, subDir));
            }
            dirStream.close();
        }
        return packages;
    }

    private String getPackagePart(String javaPathURI, Path path) {
        String pathURI = path.toUri().toString();
        String packagePart = pathURI.substring(javaPathURI.length() + 1, pathURI.length());
        return packagePart.replace("/", ".");
    }
}

