/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScenarioTest {
    SimulationDescriptor simulationDescriptor;
    Scenario scenario;
    FactIdentifier factIdentifier;
    ExpressionIdentifier expressionIdentifier;

    @Before
    public void init() {
        this.simulationDescriptor = new SimulationDescriptor();
        this.scenario = new Scenario(this.simulationDescriptor);
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECTED);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addMappingValueTest() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFactMappingValueByIndexTest() {
        this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.scenario.getFactMappingValueByIndex(0);
        this.scenario.getFactMappingValueByIndex(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getDescriptionTestFail() {
        this.scenario.getDescription();
    }

    @Test
    public void getDescriptionTest() {
        this.scenario.addMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)"Test Description");
        this.scenario.getDescription();
    }

    @Test
    public void addOrUpdateMappingValue() {
        String value1 = "Test 1";
        String value2 = "Test 2";
        FactMappingValue factMappingValue = this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value1);
        Assert.assertEquals((Object)factMappingValue.getRawValue(), (Object)value1);
        FactMappingValue factMappingValue1 = this.scenario.addOrUpdateMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value2);
        Assert.assertEquals((Object)factMappingValue, (Object)factMappingValue1);
        Assert.assertEquals((Object)factMappingValue1.getRawValue(), (Object)value2);
    }
}

