/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimulationDescriptorTest {
    SimulationDescriptor simulationDescriptor;
    FactIdentifier factIdentifier;
    ExpressionIdentifier expressionIdentifier;

    @Before
    public void init() {
        this.simulationDescriptor = new SimulationDescriptor();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECTED);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addFactMappingTest() {
        this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addFactMappingIndexTest() {
        this.simulationDescriptor.addFactMapping(1, this.factIdentifier, this.expressionIdentifier);
    }

    @Test
    public void sortByLogicalPositionTest() {
        List originalFactMappings = IntStream.range(0, 2).boxed().map(i -> this.simulationDescriptor.addFactMapping(FactIdentifier.create((String)("test " + i), (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)("test " + i), (FactMappingType)FactMappingType.EXPECTED))).collect(Collectors.toList());
        FactMapping factMappingEdited = (FactMapping)originalFactMappings.get(0);
        factMappingEdited.setLogicalPosition(100);
        this.simulationDescriptor.sortByLogicalPosition();
        List updatedFactMappings = this.simulationDescriptor.getFactMappings();
        Assert.assertNotSame(updatedFactMappings.get(0), (Object)factMappingEdited);
        Assert.assertSame(updatedFactMappings.get(updatedFactMappings.size() - 1), (Object)factMappingEdited);
        Assert.assertEquals((long)originalFactMappings.size(), (long)updatedFactMappings.size());
    }

    @Test
    public void getIndexByIdentifierTest() {
        this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        int index = this.simulationDescriptor.getIndexByIdentifier(this.factIdentifier, this.expressionIdentifier);
        Assert.assertEquals((long)0L, (long)index);
    }
}

