/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class Scenario {
    private List<FactMappingValue> factMappingValues = new ArrayList<FactMappingValue>();
    private SimulationDescriptor simulationDescriptor = new SimulationDescriptor();

    public Scenario() {
    }

    public Scenario(SimulationDescriptor simulationDescriptor) {
        this.simulationDescriptor = simulationDescriptor;
    }

    public List<FactMappingValue> getFactMappingValues() {
        return Collections.unmodifiableList(this.factMappingValues);
    }

    public FactMappingValue addMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, Object value) {
        String factName = factIdentifier.getName();
        if (this.getFactMappingValue(factIdentifier, expressionIdentifier).isPresent()) {
            throw new IllegalArgumentException("A fact value for expression '" + expressionIdentifier.getName() + "' and fact '" + factName + "' already exist");
        }
        FactMappingValue factMappingValue = new FactMappingValue(factIdentifier, expressionIdentifier, value);
        this.factMappingValues.add(factMappingValue);
        return factMappingValue;
    }

    public FactMappingValue addOrUpdateMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, Object value) {
        return this.getFactMappingValue(factIdentifier, expressionIdentifier).map(e -> {
            e.setRawValue(value);
            return e;
        }).orElseGet(() -> this.addMappingValue(factIdentifier, expressionIdentifier, value));
    }

    public Optional<FactMappingValue> getFactMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.factMappingValues.stream().filter(e -> e.getFactIdentifier().getName().equalsIgnoreCase(factIdentifier.getName()) && e.getExpressionIdentifier().equals(expressionIdentifier)).findFirst();
    }

    public Optional<FactMappingValue> getFactMappingValueByIndex(int index) {
        FactMapping factMappingByIndex;
        try {
            factMappingByIndex = this.simulationDescriptor.getFactMappingByIndex(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Impossible to retrieve FactMapping at index " + index, e);
        }
        return this.getFactMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier());
    }

    public List<FactMappingValue> getFactMappingValuesByFactIdentifier(FactIdentifier factIdentifier) {
        return this.factMappingValues.stream().filter(e -> e.getFactIdentifier().equals(factIdentifier)).collect(Collectors.toList());
    }

    public void setDescription(String name) {
        this.addOrUpdateMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, name);
    }

    public String getDescription() {
        return this.factMappingValues.stream().filter(e -> e.getExpressionIdentifier().equals(ExpressionIdentifier.DESCRIPTION) && e.getFactIdentifier().equals(FactIdentifier.DESCRIPTION)).map(e -> (String)e.getRawValue()).findFirst().orElseThrow(() -> new IllegalArgumentException("No description available"));
    }

    public Collection<String> getFactNames() {
        return this.factMappingValues.stream().map(e -> e.getFactIdentifier().getName()).collect(Collectors.toSet());
    }
}

