/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class FactMapping {
    private List<ExpressionElement> expressionElements = new LinkedList<ExpressionElement>();
    private ExpressionIdentifier expressionIdentifier;
    private FactIdentifier factIdentifier;
    private String className;
    private int logicalPosition;
    private String expressionAlias;

    public FactMapping() {
    }

    public FactMapping(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, int logicalPosition) {
        this(expressionIdentifier.getName(), factIdentifier, expressionIdentifier, logicalPosition);
    }

    public FactMapping(String expressionAlias, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, int logicalPosition) {
        this.expressionAlias = expressionAlias;
        this.expressionIdentifier = expressionIdentifier;
        this.className = factIdentifier.getClassName();
        this.factIdentifier = factIdentifier;
        this.logicalPosition = logicalPosition;
    }

    public String getFullExpression() {
        return this.expressionElements.stream().map(ExpressionElement::getStep).collect(Collectors.joining("."));
    }

    public List<ExpressionElement> getExpressionElements() {
        return this.expressionElements;
    }

    public void addExpressionElement(String stepName, String className) {
        this.className = className;
        this.expressionElements.add(new ExpressionElement(stepName));
    }

    public String getClassName() {
        return this.className;
    }

    public ExpressionIdentifier getExpressionIdentifier() {
        return this.expressionIdentifier;
    }

    public FactIdentifier getFactIdentifier() {
        return this.factIdentifier;
    }

    public void setLogicalPosition(int logicalPosition) {
        this.logicalPosition = logicalPosition;
    }

    public int getLogicalPosition() {
        return this.logicalPosition;
    }

    public String getExpressionAlias() {
        return this.expressionAlias;
    }

    public void setExpressionAlias(String expressionAlias) {
        this.expressionAlias = expressionAlias;
    }
}

