/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.Random;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.imports.Imports;

@Portable
public class ScenarioSimulationModel
implements HasImports {
    private Simulation simulation;
    private Imports imports = new Imports();

    public ScenarioSimulationModel() {
        this.simulation = new Simulation();
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        Scenario scenario = this.simulation.addScenario();
        scenario.setDescription("Scenario example");
        Random random = new Random();
        IntStream.range(1, 3).forEach(id -> {
            ExpressionIdentifier givenExpression = ExpressionIdentifier.create(String.valueOf(random.nextLong()), FactMappingType.GIVEN);
            FactIdentifier givenFact = FactIdentifier.create("GIVENFACT-" + id, String.class.getCanonicalName());
            simulationDescriptor.addFactMapping("GIVEN-" + id, givenFact, givenExpression);
            scenario.addMappingValue(givenFact, givenExpression, "given-sample-" + id);
        });
        IntStream.range(1, 3).forEach(id -> {
            ExpressionIdentifier expectedExpression = ExpressionIdentifier.create(String.valueOf(random.nextLong()), FactMappingType.EXPECTED);
            FactIdentifier expectFact = FactIdentifier.create("EXPECTEDFACT-" + id, String.class.getCanonicalName());
            simulationDescriptor.addFactMapping("EXPECTED-" + id, expectFact, expectedExpression);
            scenario.addMappingValue(expectFact, expectedExpression, "expected-sample-" + id);
        });
    }

    public ScenarioSimulationModel(Simulation simulation) {
        this.simulation = simulation;
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public void setSimulation(Simulation simulation) {
        this.simulation = simulation;
    }

    public Imports getImports() {
        return this.imports;
    }

    public void setImports(Imports imports) {
        this.imports = imports;
    }
}

