/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class SimulationDescriptor {
    private final List<FactMapping> factMappings = new ArrayList<FactMapping>();

    public List<FactMapping> getFactMappings() {
        return Collections.unmodifiableList(this.factMappings);
    }

    public void sortByLogicalPosition() {
        this.factMappings.sort(Comparator.comparing(FactMapping::getLogicalPosition));
    }

    public Set<FactIdentifier> getFactIdentifiers() {
        return this.factMappings.stream().map(FactMapping::getFactIdentifier).collect(Collectors.toSet());
    }

    public FactMapping getFactMappingByIndex(int index) {
        return this.factMappings.get(index);
    }

    public int getIndexByIdentifier(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return IntStream.range(0, this.factMappings.size()).filter(index -> {
            FactMapping factMapping = this.factMappings.get(index);
            return factMapping.getExpressionIdentifier().equals(expressionIdentifier) && factMapping.getFactIdentifier().equals(factIdentifier);
        }).findFirst().orElseThrow(() -> new IllegalArgumentException("Impossible to find a FactMapping with factIdentifier '" + factIdentifier.getName() + "' and expressionIdentifier '" + expressionIdentifier.getName() + "'"));
    }

    public List<FactMapping> getFactMappingsByFactName(String factName) {
        return this.internalFilter(e -> e.getFactIdentifier().getName().equalsIgnoreCase(factName));
    }

    public Optional<FactMapping> getFactMapping(FactIdentifier factIdentifier, ExpressionIdentifier ei) {
        List<FactMapping> factMappings = this.internalFilter(e -> e.getExpressionIdentifier().equals(ei) && e.getFactIdentifier().equals(factIdentifier));
        return factMappings.stream().findFirst();
    }

    private List<FactMapping> internalFilter(Predicate<FactMapping> predicate) {
        return this.factMappings.stream().filter(predicate).collect(Collectors.toList());
    }

    public FactMapping addFactMapping(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.addFactMapping(this.factMappings.size(), factIdentifier, expressionIdentifier);
    }

    public FactMapping addFactMapping(String expressionAlias, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.addFactMapping(this.factMappings.size(), expressionAlias, factIdentifier, expressionIdentifier);
    }

    public FactMapping addFactMapping(int index, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.addFactMapping(index, expressionIdentifier.getName(), factIdentifier, expressionIdentifier);
    }

    public FactMapping addFactMapping(int index, String expressionAlias, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        if (this.getFactMapping(factIdentifier, expressionIdentifier).isPresent()) {
            throw new IllegalArgumentException("An expression with name '" + expressionIdentifier.getName() + "' already exists for the fact '" + factIdentifier.getName() + "'");
        }
        if (index > this.factMappings.size()) {
            throw new IllegalArgumentException("Impossible to add an element at position " + index + " because there are only " + this.factMappings.size() + " elements");
        }
        FactMapping factMapping = new FactMapping(expressionAlias, factIdentifier, expressionIdentifier, index);
        this.factMappings.add(index, factMapping);
        return factMapping;
    }

    public void clear() {
        this.factMappings.clear();
    }
}

