/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScenarioTest {
    SimulationDescriptor simulationDescriptor;
    Scenario scenario;
    FactIdentifier factIdentifier;
    ExpressionIdentifier expressionIdentifier;
    Simulation simulation;

    @Before
    public void init() {
        this.simulation = new Simulation();
        this.simulationDescriptor = this.simulation.getSimulationDescriptor();
        this.scenario = this.simulation.addScenario();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECTED);
    }

    @Test
    public void removeFactMappingValueByIdentifiersTest() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertTrue((boolean)retrieved.isPresent());
        this.scenario.removeFactMappingValueByIdentifiers(this.factIdentifier, this.expressionIdentifier);
        retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void removeFactMappingValue() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertTrue((boolean)retrieved.isPresent());
        this.scenario.removeFactMappingValue((FactMappingValue)retrieved.get());
        retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test(expected=IllegalArgumentException.class)
    public void addMappingValueTest() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getDescriptionTestFail() {
        this.scenario.getDescription();
    }

    @Test
    public void getDescriptionTest() {
        this.scenario.addMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)"Test Description");
        this.scenario.getDescription();
    }

    @Test
    public void addOrUpdateMappingValue() {
        String value1 = "Test 1";
        String value2 = "Test 2";
        FactMappingValue factMappingValue = this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value1);
        Assert.assertEquals((Object)factMappingValue.getRawValue(), (Object)value1);
        FactMappingValue factMappingValue1 = this.scenario.addOrUpdateMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value2);
        Assert.assertEquals((Object)factMappingValue, (Object)factMappingValue1);
        Assert.assertEquals((Object)factMappingValue1.getRawValue(), (Object)value2);
    }

    @Test
    public void sortTest() {
        ExpressionIdentifier expressionIdentifier2 = ExpressionIdentifier.create((String)"Test expression 2", (FactMappingType)FactMappingType.GIVEN);
        this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.simulationDescriptor.addFactMapping(this.factIdentifier, expressionIdentifier2);
        this.scenario.addMappingValue(this.factIdentifier, expressionIdentifier2, (Object)"Test 2");
        FactMappingValue factMappingValue1 = this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"Test");
        Assert.assertEquals(this.scenario.getUnmodifiableFactMappingValues().get(1), (Object)factMappingValue1);
        this.scenario.sort();
        Assert.assertNotEquals(this.scenario.getUnmodifiableFactMappingValues().get(1), (Object)factMappingValue1);
        Assert.assertEquals(this.scenario.getUnmodifiableFactMappingValues().get(0), (Object)factMappingValue1);
    }
}

