/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValueOperator;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class FactMappingValue {
    private FactIdentifier factIdentifier;
    private ExpressionIdentifier expressionIdentifier;
    private Object rawValue;
    private FactMappingValueOperator operator = FactMappingValueOperator.EQUALS;

    public FactMappingValue() {
    }

    public FactMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, Object rawValue) {
        this.factIdentifier = factIdentifier;
        this.expressionIdentifier = expressionIdentifier;
        this.rawValue = rawValue;
    }

    public FactMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, Object rawValue, FactMappingValueOperator operator) {
        this(factIdentifier, expressionIdentifier, rawValue);
        this.operator = operator;
    }

    public void setRawValue(Object rawValue) {
        this.rawValue = rawValue;
    }

    public FactIdentifier getFactIdentifier() {
        return this.factIdentifier;
    }

    public ExpressionIdentifier getExpressionIdentifier() {
        return this.expressionIdentifier;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public FactMappingValueOperator getOperator() {
        return this.operator != null ? this.operator : FactMappingValue.extractOperator(this.rawValue);
    }

    public Object getCleanValue() {
        return FactMappingValue.cleanValue(this.rawValue);
    }

    FactMappingValue cloneFactMappingValue() {
        FactMappingValue cloned = new FactMappingValue();
        cloned.expressionIdentifier = this.expressionIdentifier;
        cloned.factIdentifier = this.factIdentifier;
        cloned.rawValue = this.rawValue;
        return cloned;
    }

    public static Object cleanValue(Object rawValue) {
        if (!(rawValue instanceof String)) {
            return rawValue;
        }
        String value = ((String)rawValue).trim();
        FactMappingValueOperator operator = FactMappingValueOperator.findOperator(value);
        Optional<String> first = operator.getSymbols().stream().filter(value::startsWith).findFirst();
        if (first.isPresent()) {
            String symbolToRemove = first.get();
            int index = value.indexOf(symbolToRemove);
            value = value.substring(index + symbolToRemove.length()).trim();
        }
        return value.trim();
    }

    public static FactMappingValueOperator extractOperator(Object rawValue) {
        if (!(rawValue instanceof String)) {
            return FactMappingValueOperator.EQUALS;
        }
        String value = (String)rawValue;
        return FactMappingValueOperator.findOperator(value);
    }

    public static String getPlaceHolder() {
        return "Empty value";
    }

    public static String getPlaceHolder(int index) {
        return FactMappingValue.getPlaceHolder() + " " + index;
    }

    public static String getPlaceHolder(int rowIndex, int colIndex) {
        return FactMappingValue.getPlaceHolder() + " " + rowIndex + " " + colIndex;
    }
}

