/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.Arrays;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public enum FactMappingValueOperator {
    EQUALS("="),
    NOT_EQUALS("!", "!=", "<>");

    final List<String> symbols;

    private FactMappingValueOperator(String ... symbols) {
        this.symbols = Arrays.asList(symbols);
        this.symbols.sort((a, b) -> Integer.compare(a.length(), b.length()) * -1);
    }

    public List<String> getSymbols() {
        return this.symbols;
    }

    public static FactMappingValueOperator findOperator(String rawValue) {
        String value = rawValue.trim();
        for (FactMappingValueOperator factMappingValueOperator : FactMappingValueOperator.values()) {
            if (!factMappingValueOperator.getSymbols().stream().anyMatch(value::startsWith)) continue;
            return factMappingValueOperator;
        }
        return EQUALS;
    }
}

