/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.imports.Imports;

@Portable
public class ScenarioSimulationModel
implements HasImports {
    @XStreamAsAttribute
    private String version = "1.0";
    private Simulation simulation;
    private Imports imports = new Imports();

    public ScenarioSimulationModel() {
        this.simulation = new Simulation();
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION.getName(), FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        Scenario scenario = this.simulation.addScenario();
        int row = this.simulation.getUnmodifiableScenarios().indexOf(scenario);
        scenario.setDescription(FactMappingValue.getPlaceHolder(0, 0));
        IntStream.range(1, 3).forEach(id -> {
            ExpressionIdentifier givenExpression = ExpressionIdentifier.create(row + "|" + id, FactMappingType.GIVEN);
            FactIdentifier givenFact = FactIdentifier.create((Object)((Object)FactMappingType.GIVEN) + "FACT-" + id, String.class.getCanonicalName());
            simulationDescriptor.addFactMapping(FactMapping.getPlaceHolder(FactMappingType.GIVEN, id), givenFact, givenExpression);
            scenario.addMappingValue(givenFact, givenExpression, FactMappingValue.getPlaceHolder(row, id));
        });
        IntStream.range(1, 3).forEach(id -> {
            ExpressionIdentifier expectedExpression = ExpressionIdentifier.create(row + "|" + (id += 2), FactMappingType.EXPECTED);
            FactIdentifier expectFact = FactIdentifier.create((Object)((Object)FactMappingType.EXPECTED) + "FACT-" + id, String.class.getCanonicalName());
            simulationDescriptor.addFactMapping(FactMapping.getPlaceHolder(FactMappingType.EXPECTED, id), expectFact, expectedExpression);
            scenario.addMappingValue(expectFact, expectedExpression, FactMappingValue.getPlaceHolder(row, id));
        });
    }

    public ScenarioSimulationModel(Simulation simulation) {
        this.simulation = simulation;
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public void setSimulation(Simulation simulation) {
        this.simulation = simulation;
    }

    public Imports getImports() {
        return this.imports;
    }

    public void setImports(Imports imports) {
        this.imports = imports;
    }
}

