/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class Simulation {
    private final SimulationDescriptor simulationDescriptor = new SimulationDescriptor();
    private final List<Scenario> scenarios = new LinkedList<Scenario>();

    public List<Scenario> getUnmodifiableScenarios() {
        return Collections.unmodifiableList(this.scenarios);
    }

    public void removeScenarioByIndex(int index) {
        this.scenarios.remove(index);
    }

    public void removeScenario(Scenario toRemove) {
        this.scenarios.remove(toRemove);
    }

    public SimulationDescriptor getSimulationDescriptor() {
        return this.simulationDescriptor;
    }

    public Scenario getScenarioByIndex(int index) {
        return this.scenarios.get(index);
    }

    public Scenario addScenario() {
        return this.addScenario(this.scenarios.size());
    }

    public Scenario addScenario(int index) {
        if (index < 0 || index > this.scenarios.size()) {
            throw new IllegalArgumentException("Index out of range " + index);
        }
        Scenario scenario = new Scenario(this.simulationDescriptor);
        this.scenarios.add(index, scenario);
        return scenario;
    }

    public void removeFactMappingByIndex(int index) {
        this.cleanScenarios(this.simulationDescriptor.getFactMappingByIndex(index));
        this.simulationDescriptor.removeFactMappingByIndex(index);
    }

    public void removeFactMapping(FactMapping toRemove) {
        this.cleanScenarios(toRemove);
        this.simulationDescriptor.removeFactMapping(toRemove);
    }

    public Scenario cloneScenario(int sourceIndex, int targetIndex) {
        if (sourceIndex < 0 || sourceIndex >= this.scenarios.size()) {
            throw new IllegalArgumentException("SourceIndex out of range " + sourceIndex);
        }
        if (targetIndex < 0 || targetIndex > this.scenarios.size()) {
            throw new IllegalArgumentException("TargetIndex out of range " + targetIndex);
        }
        Scenario scenarioByIndex = this.getScenarioByIndex(sourceIndex);
        Scenario clonedScenario = scenarioByIndex.cloneScenario();
        this.scenarios.add(targetIndex, clonedScenario);
        return clonedScenario;
    }

    public void clear() {
        this.simulationDescriptor.clear();
        this.scenarios.clear();
    }

    public void sort() {
        this.scenarios.forEach(Scenario::sort);
    }

    private void cleanScenarios(FactMapping toRemove) {
        this.scenarios.forEach(e -> e.removeFactMappingValueByIdentifiers(toRemove.getFactIdentifier(), toRemove.getExpressionIdentifier()));
    }
}

