/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class FactMapping {
    private List<ExpressionElement> expressionElements = new LinkedList<ExpressionElement>();
    private ExpressionIdentifier expressionIdentifier;
    private FactIdentifier factIdentifier;
    private String className;
    private String factAlias;
    private String expressionAlias;

    public FactMapping() {
    }

    public FactMapping(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        this(expressionIdentifier.getName(), factIdentifier, expressionIdentifier);
    }

    public FactMapping(String factAlias, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        this.factAlias = factAlias;
        this.expressionIdentifier = expressionIdentifier;
        this.className = factIdentifier.getClassName();
        this.factIdentifier = factIdentifier;
    }

    public String getFullExpression() {
        return this.expressionElements.stream().map(ExpressionElement::getStep).collect(Collectors.joining("."));
    }

    public List<ExpressionElement> getExpressionElements() {
        return this.expressionElements;
    }

    public void addExpressionElement(String stepName, String className) {
        this.className = className;
        this.expressionElements.add(new ExpressionElement(stepName));
    }

    public String getClassName() {
        return this.className;
    }

    public ExpressionIdentifier getExpressionIdentifier() {
        return this.expressionIdentifier;
    }

    public FactIdentifier getFactIdentifier() {
        return this.factIdentifier;
    }

    public String getFactAlias() {
        return this.factAlias;
    }

    public void setFactAlias(String factAlias) {
        this.factAlias = factAlias;
    }

    public String getExpressionAlias() {
        return this.expressionAlias;
    }

    public void setExpressionAlias(String expressionAlias) {
        this.expressionAlias = expressionAlias;
    }

    public static String getPlaceHolder(FactMappingType factMappingType) {
        return factMappingType.name();
    }

    public static String getPlaceHolder(FactMappingType factMappingType, int index) {
        return FactMapping.getPlaceHolder(factMappingType) + " " + index;
    }

    public static String getInstancePlaceHolder(int index) {
        return "INSTANCE " + index;
    }

    public static String getPropertyPlaceHolder(int index) {
        return "PROPERTY " + index;
    }
}

