/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class Scenario {
    private final List<FactMappingValue> factMappingValues = new ArrayList<FactMappingValue>();
    private SimulationDescriptor simulationDescriptor = new SimulationDescriptor();

    public Scenario() {
    }

    public Scenario(SimulationDescriptor simulationDescriptor) {
        this.simulationDescriptor = simulationDescriptor;
    }

    public List<FactMappingValue> getUnmodifiableFactMappingValues() {
        return Collections.unmodifiableList(this.factMappingValues);
    }

    public void removeFactMappingValueByIdentifiers(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        this.getFactMappingValue(factIdentifier, expressionIdentifier).ifPresent(this.factMappingValues::remove);
    }

    public void removeFactMappingValue(FactMappingValue toRemove) {
        this.factMappingValues.remove(toRemove);
    }

    public FactMappingValue addMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, Object value) {
        String factName = factIdentifier.getName();
        if (this.getFactMappingValue(factIdentifier, expressionIdentifier).isPresent()) {
            throw new IllegalArgumentException("A fact value for expression '" + expressionIdentifier.getName() + "' and fact '" + factName + "' already exist");
        }
        FactMappingValue factMappingValue = new FactMappingValue(factIdentifier, expressionIdentifier, value);
        this.factMappingValues.add(factMappingValue);
        return factMappingValue;
    }

    public FactMappingValue addOrUpdateMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, Object value) {
        return this.getFactMappingValue(factIdentifier, expressionIdentifier).map(e -> {
            e.setRawValue(value);
            return e;
        }).orElseGet(() -> this.addMappingValue(factIdentifier, expressionIdentifier, value));
    }

    public Optional<FactMappingValue> getFactMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.factMappingValues.stream().filter(e -> e.getFactIdentifier().equals(factIdentifier) && e.getExpressionIdentifier().equals(expressionIdentifier)).findFirst();
    }

    public Optional<FactMappingValue> getFactMappingValueByIndex(int index) {
        FactMapping factMappingByIndex;
        try {
            factMappingByIndex = this.simulationDescriptor.getFactMappingByIndex(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Impossible to retrieve FactMapping at index " + index, e);
        }
        return this.getFactMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier());
    }

    public List<FactMappingValue> getFactMappingValuesByFactIdentifier(FactIdentifier factIdentifier) {
        return this.factMappingValues.stream().filter(e -> e.getFactIdentifier().equals(factIdentifier)).collect(Collectors.toList());
    }

    public void setDescription(String name) {
        this.addOrUpdateMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, name);
    }

    public String getDescription() {
        return this.factMappingValues.stream().filter(e -> e.getExpressionIdentifier().equals(ExpressionIdentifier.DESCRIPTION) && e.getFactIdentifier().equals(FactIdentifier.DESCRIPTION) && e.getRawValue() != null).map(e -> (String)e.getRawValue()).findFirst().orElse("");
    }

    public Collection<String> getFactNames() {
        return this.factMappingValues.stream().map(e -> e.getFactIdentifier().getName()).collect(Collectors.toSet());
    }

    public void sort() {
        this.factMappingValues.sort((a, b) -> {
            Integer aIndex = this.simulationDescriptor.getIndexByIdentifier(a.getFactIdentifier(), a.getExpressionIdentifier());
            Integer bIndex = this.simulationDescriptor.getIndexByIdentifier(b.getFactIdentifier(), b.getExpressionIdentifier());
            return aIndex.compareTo(bIndex);
        });
    }

    public void resetErrors() {
        this.factMappingValues.forEach(elem -> elem.setError(false));
    }

    Scenario cloneScenario() {
        Scenario cloned = new Scenario(this.simulationDescriptor);
        cloned.factMappingValues.addAll(this.factMappingValues.stream().map(FactMappingValue::cloneFactMappingValue).collect(Collectors.toList()));
        return cloned;
    }
}

