/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class SimulationDescriptor {
    private final List<FactMapping> factMappings = new ArrayList<FactMapping>();
    private String dmoSession;
    private String dmnFilePath;
    private ScenarioSimulationModel.Type type;
    private String fileName;
    private String kieSession;
    private String kieBase;
    private String ruleFlowGroup;
    private String dmnNamespace;
    private String dmnName;
    private boolean skipFromBuild;

    public List<FactMapping> getUnmodifiableFactMappings() {
        return Collections.unmodifiableList(this.factMappings);
    }

    public Set<FactIdentifier> getFactIdentifiers() {
        return this.factMappings.stream().map(FactMapping::getFactIdentifier).collect(Collectors.toSet());
    }

    public String getDmoSession() {
        return this.dmoSession;
    }

    public void setDmoSession(String ruleSession) {
        this.dmoSession = ruleSession;
    }

    public String getDmnFilePath() {
        return this.dmnFilePath;
    }

    public void setDmnFilePath(String dmnFilePath) {
        this.dmnFilePath = dmnFilePath;
    }

    public ScenarioSimulationModel.Type getType() {
        return this.type;
    }

    public void setType(ScenarioSimulationModel.Type type) {
        this.type = type;
    }

    public List<FactMapping> getFactMappings() {
        return this.factMappings;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getKieSession() {
        return this.kieSession;
    }

    public void setKieSession(String kieSession) {
        this.kieSession = kieSession;
    }

    public String getKieBase() {
        return this.kieBase;
    }

    public void setKieBase(String kieBase) {
        this.kieBase = kieBase;
    }

    public String getRuleFlowGroup() {
        return this.ruleFlowGroup;
    }

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = ruleFlowGroup;
    }

    public String getDmnNamespace() {
        return this.dmnNamespace;
    }

    public void setDmnNamespace(String dmnNamespace) {
        this.dmnNamespace = dmnNamespace;
    }

    public String getDmnName() {
        return this.dmnName;
    }

    public void setDmnName(String dmnName) {
        this.dmnName = dmnName;
    }

    public boolean isSkipFromBuild() {
        return this.skipFromBuild;
    }

    public void setSkipFromBuild(boolean skipFromBuild) {
        this.skipFromBuild = skipFromBuild;
    }

    public void moveFactMapping(int oldIndex, int newIndex) {
        if (oldIndex < 0 || oldIndex >= this.factMappings.size()) {
            throw new IllegalArgumentException("Index " + oldIndex + " not found in the list");
        }
        if (newIndex < 0 || newIndex >= this.factMappings.size()) {
            throw new IllegalArgumentException("Index " + newIndex + " out of range");
        }
        FactMapping factMapping = this.factMappings.get(oldIndex);
        this.factMappings.remove(oldIndex);
        this.factMappings.add(newIndex, factMapping);
    }

    public FactMapping getFactMappingByIndex(int index) {
        return this.factMappings.get(index);
    }

    void removeFactMappingByIndex(int index) {
        this.factMappings.remove(index);
    }

    void removeFactMapping(FactMapping toRemove) {
        this.factMappings.remove(toRemove);
    }

    public int getIndexByIdentifier(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return IntStream.range(0, this.factMappings.size()).filter(index -> {
            FactMapping factMapping = this.factMappings.get(index);
            return factMapping.getExpressionIdentifier().equals(expressionIdentifier) && factMapping.getFactIdentifier().equals(factIdentifier);
        }).findFirst().orElseThrow(() -> new IllegalArgumentException("Impossible to find a FactMapping with factIdentifier '" + factIdentifier.getName() + "' and expressionIdentifier '" + expressionIdentifier.getName() + "'"));
    }

    public List<FactMapping> getFactMappingsByFactName(String factName) {
        return this.internalFilter(e -> e.getFactIdentifier().getName().equalsIgnoreCase(factName));
    }

    public Optional<FactMapping> getFactMapping(FactIdentifier factIdentifier, ExpressionIdentifier ei) {
        List<FactMapping> factMappings = this.internalFilter(e -> e.getExpressionIdentifier().equals(ei) && e.getFactIdentifier().equals(factIdentifier));
        return factMappings.stream().findFirst();
    }

    public FactMapping addFactMapping(int index, FactMapping toClone) {
        FactMapping toReturn = toClone.cloneFactMapping();
        this.factMappings.add(index, toReturn);
        return toReturn;
    }

    public FactMapping addFactMapping(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.addFactMapping(this.factMappings.size(), factIdentifier, expressionIdentifier);
    }

    public FactMapping addFactMapping(String factAlias, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.addFactMapping(this.factMappings.size(), factAlias, factIdentifier, expressionIdentifier);
    }

    public FactMapping addFactMapping(int index, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.addFactMapping(index, factIdentifier.getName(), factIdentifier, expressionIdentifier);
    }

    public FactMapping addFactMapping(int index, String factAlias, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        if (this.getFactMapping(factIdentifier, expressionIdentifier).isPresent()) {
            throw new IllegalArgumentException("An expression with name '" + expressionIdentifier.getName() + "' already exists for the fact '" + factIdentifier.getName() + "'");
        }
        if (index > this.factMappings.size()) {
            throw new IllegalArgumentException("Impossible to add an element at position " + index + " because there are only " + this.factMappings.size() + " elements");
        }
        FactMapping factMapping = new FactMapping(factAlias, factIdentifier, expressionIdentifier);
        this.factMappings.add(index, factMapping);
        return factMapping;
    }

    public void clear() {
        this.factMappings.clear();
    }

    private List<FactMapping> internalFilter(Predicate<FactMapping> predicate) {
        return this.factMappings.stream().filter(predicate).collect(Collectors.toList());
    }
}

