/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model.typedescriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class FactModelTree {
    private String factName;
    private String fullPackage;
    private String typeName;
    private boolean isSimple = false;
    private Map<String, PropertyTypeName> simpleProperties;
    private Map<String, List<String>> genericTypesMap;
    private Map<String, String> expandableProperties = new HashMap<String, String>();
    private Type type;

    public static FactModelTree ofDMO(String factName, String fullPackage, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap, String typeName) {
        if (typeName == null || factName.equals(typeName)) {
            return new FactModelTree(factName, fullPackage, simpleProperties, genericTypesMap);
        }
        return new FactModelTree(factName, fullPackage, simpleProperties, genericTypesMap, typeName);
    }

    public FactModelTree() {
    }

    public FactModelTree(String factName, String fullPackage, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap) {
        this(factName, fullPackage, simpleProperties, genericTypesMap, Type.UNDEFINED);
    }

    public FactModelTree(String factName, String fullPackage, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap, String typeName) {
        this(factName, fullPackage, simpleProperties, genericTypesMap, Type.UNDEFINED, typeName);
    }

    public FactModelTree(String factName, String fullPackage, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap, Type type) {
        this(factName, fullPackage, simpleProperties, genericTypesMap, type, null);
    }

    public FactModelTree(String factName, String fullPackage, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap, Type type, String typeName) {
        this.factName = factName;
        this.fullPackage = fullPackage;
        this.simpleProperties = simpleProperties;
        this.genericTypesMap = genericTypesMap;
        this.type = type;
        this.typeName = typeName;
    }

    public String getFactName() {
        return this.factName;
    }

    public String getFullPackage() {
        return this.fullPackage;
    }

    public Map<String, PropertyTypeName> getSimpleProperties() {
        return this.simpleProperties;
    }

    public Map<String, String> getExpandableProperties() {
        return this.expandableProperties;
    }

    public Map<String, List<String>> getGenericTypesMap() {
        return this.genericTypesMap;
    }

    public void addSimpleProperty(String propertyName, PropertyTypeName propertyTypeName) {
        this.simpleProperties.put(propertyName, propertyTypeName);
    }

    public void addExpandableProperty(String propertyName, String propertyType) {
        this.expandableProperties.put(propertyName, propertyType);
    }

    public List<String> getGenericTypeInfo(String propertyName) {
        return this.genericTypesMap.getOrDefault(propertyName, new ArrayList());
    }

    public void removeSimpleProperty(String propertyName) {
        this.simpleProperties.remove(propertyName);
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean simple) {
        this.isSimple = simple;
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName != null ? this.typeName : this.factName;
    }

    public String getFullTypeName() {
        return this.fullPackage == null || this.fullPackage.isEmpty() ? this.getTypeName() : this.fullPackage + "." + this.getTypeName();
    }

    public FactModelTree cloneFactModelTree() {
        HashMap<String, PropertyTypeName> clonedSimpleProperties = new HashMap<String, PropertyTypeName>(this.simpleProperties);
        Map<String, List<String>> clonedGenericTypesMap = this.genericTypesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            ArrayList toReturn = new ArrayList();
            toReturn.addAll((Collection)e.getValue());
            return toReturn;
        }));
        FactModelTree toReturn = new FactModelTree(this.factName, this.fullPackage, clonedSimpleProperties, clonedGenericTypesMap, this.type, this.typeName);
        toReturn.expandableProperties = new HashMap<String, String>(this.expandableProperties);
        toReturn.isSimple = this.isSimple;
        return toReturn;
    }

    public String toString() {
        return "FactModelTree{factName='" + this.factName + '\'' + "typeName='" + this.typeName + '\'' + ", simpleProperties=" + this.simpleProperties + ", expandableProperties=" + this.expandableProperties + '}';
    }

    public static class PropertyTypeName {
        private String typeName;
        private Optional<String> baseTypeName;

        public PropertyTypeName() {
            this.typeName = null;
            this.baseTypeName = Optional.empty();
        }

        public PropertyTypeName(String typeName) {
            this.typeName = typeName;
            this.baseTypeName = Optional.empty();
        }

        public PropertyTypeName(String typeName, String baseTypeName) {
            this.typeName = typeName;
            this.baseTypeName = Optional.ofNullable(baseTypeName);
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Optional<String> getBaseTypeName() {
            return this.baseTypeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public void setBaseTypeName(String baseTypeName) {
            this.baseTypeName = Optional.ofNullable(baseTypeName);
        }

        public String getPropertyTypeNameToVisualize() {
            return this.baseTypeName.orElse(this.typeName.replace('$', '.'));
        }
    }

    public static enum Type {
        INPUT,
        DECISION,
        UNDEFINED;

    }
}

