/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import junit.framework.TestCase;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.drools.workbench.screens.scenariosimulation.utils.ScenarioSimulationI18nServerMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FactMappingValidationErrorTest {
    private FactMapping factMapping;

    @Before
    public void setup() {
        this.factMapping = new FactMapping(FactIdentifier.create((String)"myType", (String)"tMYTYPE"), ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        this.factMapping.setFactAlias("FactAlias");
        this.factMapping.setExpressionAlias("ExpressionAlias");
    }

    @Test
    public void createFieldChangedError() {
        FactMappingValidationError error = FactMappingValidationError.createFieldChangedError((FactMapping)this.factMapping, (String)"tNEWTYPE");
        TestCase.assertEquals((String)"FactAlias.ExpressionAlias", (String)error.getErrorId());
        TestCase.assertEquals((Object)ScenarioSimulationI18nServerMessage.SCENARIO_VALIDATION_FIELD_CHANGED_ERROR, (Object)error.getServerMessage());
        TestCase.assertEquals((int)2, (int)error.getParameters().length);
        TestCase.assertEquals((String)"tMYTYPE", (String)error.getParameters()[0]);
        TestCase.assertEquals((String)"tNEWTYPE", (String)error.getParameters()[1]);
        Assert.assertNull((Object)error.getErrorMessage());
    }

    @Test
    public void createFieldAddedConstraintError() {
        FactMappingValidationError error = FactMappingValidationError.createFieldAddedConstraintError((FactMapping)this.factMapping);
        TestCase.assertEquals((String)"FactAlias.ExpressionAlias", (String)error.getErrorId());
        TestCase.assertEquals((Object)ScenarioSimulationI18nServerMessage.SCENARIO_VALIDATION_FIELD_ADDED_CONSTRAINT_ERROR, (Object)error.getServerMessage());
        TestCase.assertEquals((int)0, (int)error.getParameters().length);
        Assert.assertNull((Object)error.getErrorMessage());
    }

    @Test
    public void createFieldRemovedConstraintError() {
        FactMappingValidationError error = FactMappingValidationError.createFieldRemovedConstraintError((FactMapping)this.factMapping);
        TestCase.assertEquals((String)"FactAlias.ExpressionAlias", (String)error.getErrorId());
        TestCase.assertEquals((Object)ScenarioSimulationI18nServerMessage.SCENARIO_VALIDATION_FIELD_REMOVED_CONSTRAINT_ERROR, (Object)error.getServerMessage());
        TestCase.assertEquals((int)0, (int)error.getParameters().length);
        Assert.assertNull((Object)error.getErrorMessage());
    }

    @Test
    public void createNodeChangedError() {
        FactMappingValidationError error = FactMappingValidationError.createNodeChangedError((FactMapping)this.factMapping, (String)"tNEWTYPE");
        TestCase.assertEquals((String)"FactAlias.ExpressionAlias", (String)error.getErrorId());
        TestCase.assertEquals((Object)ScenarioSimulationI18nServerMessage.SCENARIO_VALIDATION_NODE_CHANGED_ERROR, (Object)error.getServerMessage());
        TestCase.assertEquals((int)2, (int)error.getParameters().length);
        TestCase.assertEquals((String)"tMYTYPE", (String)error.getParameters()[0]);
        TestCase.assertEquals((String)"tNEWTYPE", (String)error.getParameters()[1]);
        Assert.assertNull((Object)error.getErrorMessage());
    }

    @Test
    public void createGenericError() {
        FactMappingValidationError error = FactMappingValidationError.createGenericError((FactMapping)this.factMapping, (String)"err");
        TestCase.assertEquals((String)"FactAlias.ExpressionAlias", (String)error.getErrorId());
        Assert.assertNull((Object)error.getServerMessage());
        TestCase.assertEquals((String)"err", (String)error.getErrorMessage());
        Assert.assertNull((Object)error.getParameters());
    }
}

